/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.text;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record BookText(boolean translation, String content) {
    public static final Codec<BookText> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("translation").forGetter(BookText::translation), (App)Codec.STRING.fieldOf("content").forGetter(BookText::content)).apply((Applicative)instance, BookText::new));
    public static final Codec<List<BookText>> LIST_CODEC = CODEC.listOf();

    public String getString() {
        if (this.translation) {
            Language language = Language.getInstance();
            return language.getOrDefault(this.content);
        }
        return this.content;
    }

    public static List<Component> parse(String input) {
        ArrayList<Component> result = new ArrayList<Component>();
        StringBuilder currentText = new StringBuilder();
        FormatState currentState = new FormatState();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '$' && i + 1 < input.length() && input.charAt(i + 1) == '{') {
                int endIndex;
                if (!currentText.isEmpty()) {
                    result.add(BookText.createText(currentText.toString(), currentState));
                    currentText.setLength(0);
                }
                if ((endIndex = input.indexOf(125, i + 2)) == -1) {
                    currentText.append("${");
                    i += 2;
                    continue;
                }
                String command = input.substring(i + 2, endIndex);
                BookText.processCommand(command, currentState);
                i = endIndex + 1;
                continue;
            }
            currentText.append(c);
            ++i;
        }
        if (!currentText.isEmpty()) {
            result.add(BookText.createText(currentText.toString(), currentState));
        }
        return result;
    }

    private static void processCommand(String command, FormatState state) {
        String style;
        String color;
        if (command.equals("r")) {
            state.color = null;
            state.style = null;
            state.link = null;
        }
        if (command.startsWith("color:") && (color = command.substring(6).trim()).startsWith("#")) {
            try {
                state.color = Integer.parseInt(color.substring(1), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (command.startsWith("style:") && (style = command.substring(6).trim()).length() == 1) {
            state.style = ChatFormatting.getByCode((char)style.charAt(0));
        }
        if (command.startsWith("link:")) {
            state.link = command.substring(5).trim();
        }
    }

    private static Component createText(String content, FormatState state) {
        MutableComponent text = Component.literal((String)content);
        if (state.color != null) {
            text.withColor(state.color.intValue());
        }
        if (state.style != null) {
            text.withStyle(state.style);
        }
        if (state.link != null) {
            text.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, state.link)));
        }
        return text;
    }

    private static class FormatState {
        Integer color = null;
        ChatFormatting style = null;
        String link = null;

        private FormatState() {
        }
    }
}

