/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.block.DryingRackBlock;
import cn.leolezury.eternalstarlight.common.block.entity.SimpleContainerBlockEntity;
import cn.leolezury.eternalstarlight.common.item.recipe.DryingRecipe;
import cn.leolezury.eternalstarlight.common.item.recipe.DryingRecipeInput;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESRecipes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class DryingRackBlockEntity
extends SimpleContainerBlockEntity {
    private static final String TAG_DRYING_TICKS = "drying_ticks";
    private final RecipeManager.CachedCheck<DryingRecipeInput, DryingRecipe> quickCheck = RecipeManager.createCheck(ESRecipes.DRYING.get());
    private boolean lastLit;
    private int dryingTicks = 0;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    protected DryingRackBlockEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public DryingRackBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(ESBlockEntities.DRYING_RACK.get(), blockPos, blockState);
    }

    public ItemStack getItem() {
        return (ItemStack)this.items.getFirst();
    }

    public void setItem(ItemStack item) {
        this.setItem(0, item);
        this.dryingTicks = 0;
    }

    public boolean canBeDried(ItemStack stack, boolean fireBelow) {
        if (this.level == null) {
            return false;
        }
        List list = this.level.getRecipeManager().getAllRecipesFor(ESRecipes.DRYING.get());
        for (RecipeHolder holder : list) {
            DryingRecipe recipe = (DryingRecipe)holder.value();
            if (fireBelow != recipe.fireBelow() || !recipe.input().test(stack)) continue;
            return true;
        }
        return false;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DryingRackBlockEntity entity) {
        if (!level.isClientSide) {
            if (!entity.getItem().isEmpty()) {
                Optional optionalRecipe;
                boolean lit = (Boolean)state.getValue((Property)DryingRackBlock.LIT);
                if (entity.lastLit != lit) {
                    entity.dryingTicks = 0;
                    entity.lastLit = lit;
                }
                if ((optionalRecipe = entity.quickCheck.getRecipeFor((RecipeInput)new DryingRecipeInput((ItemStack)entity.items.getFirst(), lit), level)).isPresent()) {
                    DryingRecipe recipe = (DryingRecipe)((RecipeHolder)optionalRecipe.get()).value();
                    ++entity.dryingTicks;
                    if (entity.dryingTicks > recipe.durationTicks()) {
                        entity.dryingTicks = 0;
                        entity.setItem(recipe.output().copy());
                    }
                } else {
                    entity.dryingTicks = 0;
                }
            } else {
                entity.dryingTicks = 0;
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }

    public void setChanged() {
        super.setChanged();
        if (this.getLevel() != null) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.dryingTicks = compoundTag.getInt(TAG_DRYING_TICKS);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt(TAG_DRYING_TICKS, this.dryingTicks);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int getContainerSize() {
        return 1;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        BlockState state = this.getBlockState();
        return this.canBeDried(stack, state.hasProperty((Property)DryingRackBlock.LIT) && (Boolean)state.getValue((Property)DryingRackBlock.LIT) != false) && this.getItem(index).isEmpty() && stack.getCount() <= this.getMaxStackSize();
    }
}

