/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.entity.DuskLightReceptor;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDuskLightBlockEntity
extends BlockEntity
implements DuskLightReceptor {
    private static final String TAG_LENGTH = "length";
    private static final String TAG_LIT = "lit";
    public static final float MAX_LENGTH = 30.0f;
    protected int ticksLeft = 0;
    private boolean lit = false;
    private final Object2FloatMap<Direction> lengths = new Object2FloatArrayMap();
    private final Object2FloatMap<Direction> beamProgresses = new Object2FloatArrayMap();
    private final Object2FloatMap<Direction> oldBeamProgresses = new Object2FloatArrayMap();
    protected boolean alwaysActivated = false;

    public AbstractDuskLightBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public boolean isLit() {
        return this.lit;
    }

    public Object2FloatMap<Direction> getBeamProgresses() {
        return this.beamProgresses;
    }

    public Object2FloatMap<Direction> getOldBeamProgresses() {
        return this.oldBeamProgresses;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        for (Direction direction : Direction.values()) {
            compoundTag.putFloat("length_" + direction.getName(), this.lengths.getOrDefault((Object)direction, 0.0f));
        }
        compoundTag.putBoolean(TAG_LIT, this.lit);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        for (Direction direction : Direction.values()) {
            this.lengths.put((Object)direction, compoundTag.getFloat("length_" + direction.getName()));
        }
        this.lit = compoundTag.getBoolean(TAG_LIT);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }

    protected abstract boolean isFaceActivated(BlockState var1, Direction var2);

    @Override
    public void lightUp(Level level, BlockPos pos, Direction sourceDir) {
        this.ticksLeft = 5;
    }

    public static boolean canPassThrough(BlockState state) {
        if (state.is(ESTags.Blocks.DUSK_LIGHT_ALWAYS_PASSABLE)) {
            return true;
        }
        if (state.is(ESTags.Blocks.DUSK_LIGHT_ALWAYS_UNPASSABLE)) {
            return false;
        }
        return state.getBlock() instanceof HalfTransparentBlock;
    }

    public static boolean canDestroy(BlockState state) {
        return state.is(ESTags.Blocks.DUSK_LIGHT_DESTROYABLES);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractDuskLightBlockEntity entity) {
        if (level.isClientSide) {
            entity.oldBeamProgresses.clear();
            entity.oldBeamProgresses.putAll(entity.beamProgresses);
            for (Direction direction : Direction.values()) {
                if (!entity.beamProgresses.containsKey((Object)direction)) {
                    entity.beamProgresses.put((Object)direction, 0.0f);
                }
                if (entity.isFaceActivated(state, direction) && entity.lit) {
                    entity.beamProgresses.put((Object)direction, Mth.clamp((float)(entity.beamProgresses.getFloat((Object)direction) + 0.3f), (float)0.0f, (float)(entity.lengths.getOrDefault((Object)direction, 0.0f) / 30.0f)));
                    EternalStarlight.getClientHelper().spawnManaCrystalItemParticles(ManaType.BLAZE, pos.getCenter().add(new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ()).scale((double)entity.lengths.getOrDefault((Object)direction, 0.0f) + 0.5)));
                    continue;
                }
                entity.beamProgresses.put((Object)direction, Mth.clamp((float)(entity.beamProgresses.getFloat((Object)direction) - 0.3f), (float)0.0f, (float)1.0f));
            }
        } else {
            Object2FloatArrayMap oldLengths = new Object2FloatArrayMap(entity.lengths);
            boolean oldLit = entity.lit;
            if (entity.lit) {
                for (Direction direction : Direction.values()) {
                    Vec3 toPos;
                    if (!entity.isFaceActivated(state, direction)) continue;
                    Vec3 fromPos = pos.getCenter().add(new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ()).scale(0.51));
                    BlockHitResult result = level.clip(new ClipContext(fromPos, toPos = fromPos.add(new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ()).scale(30.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()){

                        public VoxelShape getBlockShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
                            return AbstractDuskLightBlockEntity.canPassThrough(blockState) ? Shapes.empty() : super.getBlockShape(blockState, blockGetter, blockPos);
                        }
                    });
                    if (result.getType() != HitResult.Type.MISS) {
                        entity.lengths.put((Object)direction, (float)result.getLocation().subtract(fromPos).length());
                        BlockEntity blockEntity = level.getBlockEntity(result.getBlockPos());
                        if (blockEntity instanceof DuskLightReceptor) {
                            DuskLightReceptor receptor = (DuskLightReceptor)blockEntity;
                            receptor.lightUp(level, result.getBlockPos(), direction.getOpposite());
                        }
                        if (AbstractDuskLightBlockEntity.canDestroy(level.getBlockState(result.getBlockPos()))) {
                            level.destroyBlock(result.getBlockPos(), true);
                        }
                    } else {
                        entity.lengths.put((Object)direction, 30.0f);
                    }
                    List entities = level.getEntitiesOfClass(Entity.class, new AABB(fromPos.subtract(direction.getAxis() == Direction.Axis.X ? 0.0 : 0.25, direction.getAxis() == Direction.Axis.Y ? 0.0 : 0.25, direction.getAxis() == Direction.Axis.Z ? 0.0 : 0.25), fromPos.relative(direction, (double)entity.lengths.getOrDefault((Object)direction, 0.0f)).add(direction.getAxis() == Direction.Axis.X ? 0.0 : 0.25, direction.getAxis() == Direction.Axis.Y ? 0.0 : 0.25, direction.getAxis() == Direction.Axis.Z ? 0.0 : 0.25)));
                    for (Entity e : entities) {
                        if (e instanceof ItemEntity) continue;
                        e.setRemainingFireTicks(Math.max(e.getRemainingFireTicks(), 100));
                    }
                }
            }
            if (entity.alwaysActivated) {
                entity.ticksLeft = 5;
            }
            --entity.ticksLeft;
            if (entity.ticksLeft < 0) {
                entity.ticksLeft = 0;
            }
            entity.lit = entity.ticksLeft > 0;
            boolean lengthsChanged = false;
            for (Direction direction : Direction.values()) {
                if (!((double)Math.abs(entity.lengths.getOrDefault((Object)direction, 0.0f) - oldLengths.getOrDefault((Object)direction, 0.0f)) > 0.01)) continue;
                lengthsChanged = true;
                break;
            }
            if (lengthsChanged || oldLit != entity.lit) {
                entity.markUpdated();
            }
        }
    }

    public void markUpdated() {
        if (this.getLevel() != null) {
            this.setChanged();
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

