/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ShadegrieveBlock
extends Block {
    public static final MapCodec<ShadegrieveBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("particles").forGetter(block -> block.particles), (App)ShadegrieveBlock.propertiesCodec()).apply((Applicative)instance, ShadegrieveBlock::new));
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    private final boolean particles;

    public ShadegrieveBlock(boolean particles, BlockBehaviour.Properties properties) {
        super(properties);
        this.particles = particles;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<ShadegrieveBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        boolean sturdy = true;
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        List<Direction> xzDirections = Arrays.stream(Direction.values()).filter(dir -> dir.getAxis() != Direction.Axis.Y).toList();
        for (Direction dir2 : xzDirections) {
            sturdy &= level.getBlockState(blockPos.above()).isFaceSturdy((BlockGetter)level, blockPos.above(), dir2);
        }
        return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(!level.getBlockState(blockPos.above()).is((Block)this) && sturdy));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState blockState2, LevelAccessor level, BlockPos blockPos, BlockPos blockPos2) {
        boolean sturdy = true;
        List<Direction> xzDirections = Arrays.stream(Direction.values()).filter(dir -> dir.getAxis() != Direction.Axis.Y).toList();
        for (Direction dir2 : xzDirections) {
            sturdy &= level.getBlockState(blockPos.above()).isFaceSturdy((BlockGetter)level, blockPos.above(), dir2);
        }
        return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(!level.getBlockState(blockPos.above()).is((Block)this) && sturdy));
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (this.particles && randomSource.nextInt(5) == 0) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)blockPos, (ParticleOptions)((ParticleOptions)ESParticles.SHADEGRIEVE_LEAVES.get()), (IntProvider)ConstantInt.of((int)1));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TOP});
    }
}

