/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.entity.DryingRackBlockEntity;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DryingRackBlock
extends BaseEntityBlock {
    public static final MapCodec<DryingRackBlock> CODEC = DryingRackBlock.simpleCodec(DryingRackBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty CAMPFIRE = BooleanProperty.create((String)"campfire");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape AXIS_X_SHAPE = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape AXIS_Z_SHAPE = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public DryingRackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CAMPFIRE, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        return belowState.isFaceSturdy((BlockGetter)level, pos, Direction.UP) || belowState.is(BlockTags.CAMPFIRES) || belowState.is((Block)this) && ((Direction)belowState.getValue((Property)FACING)).getAxis() == ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (this.canSurvive(state, (LevelReader)level, pos)) {
            if (direction == Direction.DOWN && neighborState.is(BlockTags.CAMPFIRES)) {
                return (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(neighborState.hasProperty((Property)LIT) && (Boolean)neighborState.getValue((Property)LIT) != false));
            }
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        BlockState belowState = context.getLevel().getBlockState(context.getClickedPos().below());
        if (state != null) {
            if (belowState.is(BlockTags.CAMPFIRES)) {
                state = (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(belowState.hasProperty((Property)LIT) && (Boolean)belowState.getValue((Property)LIT) != false))).setValue((Property)CAMPFIRE, (Comparable)Boolean.valueOf(true));
            }
            state = (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        }
        return state;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DryingRackBlockEntity) {
            DryingRackBlockEntity entity = (DryingRackBlockEntity)blockEntity;
            if (entity.getItem().isEmpty() && !stack.isEmpty() && entity.canBeDried(stack, (Boolean)state.getValue((Property)LIT))) {
                if (!level.isClientSide) {
                    entity.setItem(stack.copyWithCount(1));
                    stack.consume(1, (LivingEntity)player);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!entity.getItem().isEmpty() && (ItemStack.isSameItemSameComponents((ItemStack)entity.getItem(), (ItemStack)stack) || stack.isEmpty())) {
                int mergedCount = entity.getItem().getCount() + stack.getCount();
                int maxSize = stack.getMaxStackSize();
                if (!level.isClientSide) {
                    player.setItemInHand(hand, entity.getItem().copyWithCount(Math.min(mergedCount, maxSize)));
                    if (mergedCount <= maxSize) {
                        entity.setItem(ItemStack.EMPTY);
                    } else {
                        entity.setItem(entity.getItem().copyWithCount(mergedCount - maxSize));
                    }
                }
                if (stack.getCount() < maxSize) {
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return ((Direction)blockState.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? AXIS_X_SHAPE : AXIS_Z_SHAPE;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, CAMPFIRE, FACING});
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DryingRackBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return DryingRackBlock.createTickerHelper(blockEntityType, ESBlockEntities.DRYING_RACK.get(), DryingRackBlockEntity::tick);
    }
}

