/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CaveMossCarpetBlock
extends CarpetBlock {
    public static final MapCodec<CaveMossCarpetBlock> CODEC = CaveMossCarpetBlock.simpleCodec(CaveMossCarpetBlock::new);
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");

    public MapCodec<CaveMossCarpetBlock> codec() {
        return CODEC;
    }

    public CaveMossCarpetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        boolean sturdy = true;
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        List<Direction> xzDirections = Arrays.stream(Direction.values()).filter(dir -> dir.getAxis() != Direction.Axis.Y).toList();
        for (Direction dir2 : xzDirections) {
            sturdy &= level.getBlockState(blockPos.below()).isFaceSturdy((BlockGetter)level, blockPos.below(), dir2);
        }
        return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(!level.getBlockState(blockPos.below()).is((Block)this) && !level.getBlockState(blockPos.below()).is((Block)ESBlocks.CAVE_MOSS_BLOCK.get()) && sturdy));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState blockState2, LevelAccessor level, BlockPos blockPos, BlockPos blockPos2) {
        boolean sturdy = true;
        List<Direction> xzDirections = Arrays.stream(Direction.values()).filter(dir -> dir.getAxis() != Direction.Axis.Y).toList();
        for (Direction dir2 : xzDirections) {
            sturdy &= level.getBlockState(blockPos.below()).isFaceSturdy((BlockGetter)level, blockPos.below(), dir2);
        }
        return super.updateShape((BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(!level.getBlockState(blockPos.below()).is((Block)this) && !level.getBlockState(blockPos.below()).is((Block)ESBlocks.CAVE_MOSS_BLOCK.get()) && sturdy)), direction, blockState2, level, blockPos, blockPos2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BOTTOM});
    }
}

