/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.DirectionalBudBlock;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BouldershroomBlock
extends DirectionalBudBlock
implements BonemealableBlock {
    public static final MapCodec<BouldershroomBlock> CODEC = BouldershroomBlock.simpleCodec(BouldershroomBlock::new);

    public BouldershroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected double getShapeWidth() {
        return 6.0;
    }

    @Override
    protected double getShapeHeight() {
        return 6.0;
    }

    protected MapCodec<BouldershroomBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos attachPos = pos.relative(direction.getOpposite());
        BlockState attachState = level.getBlockState(attachPos);
        return attachState.isFaceSturdy((BlockGetter)level, attachPos, direction) && !(attachState.getBlock() instanceof HugeMushroomBlock);
    }

    private static boolean canReplace(BlockState state) {
        return (state.isAir() || state.canBeReplaced()) && !(state.getBlock() instanceof LiquidBlock);
    }

    public static boolean growMushroom(ServerLevelAccessor level, RandomSource random, BlockPos origin, Direction growDirection) {
        Direction capDirection;
        BlockPos attachPos = origin.relative(growDirection.getOpposite());
        BlockState attachState = level.getBlockState(attachPos);
        if (!attachState.isFaceSturdy((BlockGetter)level, attachPos, growDirection)) {
            return false;
        }
        ArrayList<BlockPos> stemPositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> capPositions = new ArrayList<BlockPos>();
        List<Direction> randomOffsetDirs = Arrays.stream(Direction.values()).filter(dir -> dir.getAxis() != growDirection.getAxis()).toList();
        int height = random.nextInt(6, 12);
        int distToNextTurn = random.nextInt(height / 3) + 2;
        BlockPos.MutableBlockPos pos = origin.mutable();
        for (int i = 0; i < height; ++i) {
            stemPositions.add(pos.immutable());
            if (!BouldershroomBlock.canReplace(level.getBlockState((BlockPos)pos))) {
                return false;
            }
            if (distToNextTurn <= 0) {
                Direction offsetDir = randomOffsetDirs.get(random.nextInt(randomOffsetDirs.size()));
                int turnLength = random.nextInt(height / 3) + 2;
                for (int j = 0; j < turnLength; ++j) {
                    pos.move(offsetDir);
                    stemPositions.add(pos.immutable());
                    if (BouldershroomBlock.canReplace(level.getBlockState((BlockPos)pos))) continue;
                    return false;
                }
                distToNextTurn = random.nextInt(height / 3) + 2;
            }
            pos.move(growDirection);
            --distToNextTurn;
        }
        pos.move(growDirection.getOpposite());
        int capRadius = random.nextInt(4, 7);
        Direction direction = capDirection = growDirection != Direction.DOWN ? Direction.UP : Direction.DOWN;
        if (capDirection == Direction.UP && growDirection != Direction.UP) {
            boolean cap = false;
            for (int h = 0; h < height; ++h) {
                pos.move(Direction.UP);
                boolean canPlaceCap = true;
                for (int i = -capRadius; i <= capRadius; ++i) {
                    for (int j = -capRadius; j <= capRadius; ++j) {
                        BlockPos capPos;
                        if (i * i + j * j > capRadius * capRadius || !stemPositions.contains(capPos = pos.offset(i, 0, j))) continue;
                        canPlaceCap = false;
                    }
                }
                stemPositions.add(pos.immutable());
                if (!BouldershroomBlock.canReplace(level.getBlockState((BlockPos)pos))) {
                    return false;
                }
                if (!canPlaceCap) continue;
                cap = true;
                break;
            }
            if (!cap) {
                return false;
            }
        }
        ArrayList<BlockPos> fullCapPositions = new ArrayList<BlockPos>();
        for (int layerRadius = capRadius; layerRadius > 0; layerRadius -= 2) {
            for (int i = -layerRadius; i <= layerRadius; ++i) {
                for (int j = -layerRadius; j <= layerRadius; ++j) {
                    boolean hollow;
                    if (i * i + j * j > layerRadius * layerRadius) continue;
                    BlockPos capPos = pos.offset(i, 0, j);
                    boolean bl = hollow = layerRadius == capRadius && i * i + j * j <= (layerRadius - 2) * (layerRadius - 2);
                    if (!hollow) {
                        capPositions.add(capPos);
                        if (!BouldershroomBlock.canReplace(level.getBlockState(capPos))) {
                            return false;
                        }
                        if (layerRadius != capRadius) {
                            for (Direction dir2 : Direction.values()) {
                                BlockPos extraPos;
                                if (random.nextInt(8) != 0 || dir2 == capDirection.getOpposite() || !BouldershroomBlock.canReplace(level.getBlockState(extraPos = capPos.relative(dir2))) || stemPositions.contains(extraPos)) continue;
                                capPositions.add(extraPos);
                            }
                        }
                    }
                    fullCapPositions.add(capPos);
                }
            }
            pos.move(capDirection);
        }
        for (BlockPos blockPos : stemPositions) {
            BlockPos belowPos;
            int i;
            BlockState state = ESBlocks.BOULDERSHROOM_STEM.get().defaultBlockState();
            for (Direction dir3 : Direction.values()) {
                if (!stemPositions.contains(blockPos.relative(dir3)) && !capPositions.contains(blockPos.relative(dir3))) continue;
                state = (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(dir3), (Comparable)Boolean.valueOf(false));
            }
            level.setBlock(blockPos, state, 3);
            if (random.nextInt(8) != 0) continue;
            int maxLength = 0;
            int randLength = random.nextInt(1, 4);
            for (i = 1; i < randLength + 1 && !stemPositions.contains(belowPos = blockPos.below(i)) && !capPositions.contains(belowPos) && BouldershroomBlock.canReplace(level.getBlockState(belowPos)); ++i) {
                ++maxLength;
            }
            for (i = 1; i <= maxLength; ++i) {
                level.setBlock(blockPos.below(i), i == maxLength ? ESBlocks.BOULDERSHROOM_ROOTS.get().defaultBlockState() : ESBlocks.BOULDERSHROOM_ROOTS_PLANT.get().defaultBlockState(), 3);
            }
        }
        for (BlockPos blockPos : capPositions) {
            BlockPos belowPos;
            int i;
            BlockState state = (BlockState)ESBlocks.BOULDERSHROOM_BLOCK.get().defaultBlockState().setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(capDirection.getOpposite()), (Comparable)Boolean.valueOf(false));
            for (Direction dir4 : Direction.values()) {
                if (!stemPositions.contains(blockPos.relative(dir4)) && !capPositions.contains(blockPos.relative(dir4)) && !fullCapPositions.contains(blockPos.relative(dir4))) continue;
                state = (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(dir4), (Comparable)Boolean.valueOf(false));
            }
            level.setBlock(blockPos, state, 3);
            if (random.nextInt(5) != 0) continue;
            int maxLength = 0;
            int randLength = random.nextInt(2, 7);
            for (i = 1; i < randLength + 1 && !stemPositions.contains(belowPos = blockPos.below(i)) && !capPositions.contains(belowPos) && BouldershroomBlock.canReplace(level.getBlockState(belowPos)); ++i) {
                ++maxLength;
            }
            for (i = 1; i <= maxLength; ++i) {
                level.setBlock(blockPos.below(i), i == maxLength ? ESBlocks.BOULDERSHROOM_ROOTS.get().defaultBlockState() : ESBlocks.BOULDERSHROOM_ROOTS_PLANT.get().defaultBlockState(), 3);
            }
        }
        return true;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.nextFloat() < 0.4;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource random, BlockPos pos, BlockState state) {
        serverLevel.removeBlock(pos, false);
        if (!BouldershroomBlock.growMushroom((ServerLevelAccessor)serverLevel, random, pos, (Direction)state.getValue((Property)FACING))) {
            serverLevel.setBlock(pos, state, 3);
        }
    }
}

