/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.common.block;

import cy.jdkdigital.dyenamics.common.blockentity.DyenamicShulkerBoxBlockEntity;
import cy.jdkdigital.dyenamics.core.init.BlockEntityInit;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class DyenamicShulkerBoxBlock
extends ShulkerBoxBlock {
    private final DyenamicDyeColor color;

    public DyenamicShulkerBoxBlock(DyenamicDyeColor colorIn, BlockBehaviour.Properties properties) {
        super(DyeColor.PURPLE, properties);
        this.color = colorIn;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new DyenamicShulkerBoxBlockEntity(this.color, pPos, pState);
    }

    public DyenamicDyeColor getDyenamicColor() {
        return this.color;
    }

    public static ItemStack getDyenamicColoredItemStack(DyenamicDyeColor colorIn) {
        return new ItemStack((ItemLike)BlockInit.DYED_BLOCKS.get(colorIn.getSerializedName()).get("shulker_box").get());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return DyenamicShulkerBoxBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityInit.SHULKER_BOX.get()), ShulkerBoxBlockEntity::tick);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerboxBlockEntity = (ShulkerBoxBlockEntity)blockEntity;
            if (!level.isClientSide && player.isCreative() && !shulkerboxBlockEntity.isEmpty()) {
                ItemStack itemstack = DyenamicShulkerBoxBlock.getDyenamicColoredItemStack(this.getDyenamicColor());
                shulkerboxBlockEntity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
                if (shulkerboxBlockEntity.hasCustomName()) {
                    itemstack.set(DataComponents.ITEM_NAME, (Object)shulkerboxBlockEntity.getCustomName());
                }
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
                itementity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itementity);
            } else {
                shulkerboxBlockEntity.unpackLootTable(player);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }
}

