/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record RandomWoodToItemListing(boolean buys, String childKey, int woodPrice, ItemCost emeralds, int maxTrades, int xp, float priceMult, int level, List<WoodType> blacklist) implements ModItemListing
{
    public static final MapCodec<RandomWoodToItemListing> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("buys", (Object)true).forGetter(RandomWoodToItemListing::buys), (App)Codec.STRING.fieldOf("wood_block").forGetter(RandomWoodToItemListing::childKey), (App)ExtraCodecs.POSITIVE_INT.fieldOf("wood_block_amount").forGetter(RandomWoodToItemListing::woodPrice), (App)ItemCost.CODEC.fieldOf("emeralds").forGetter(RandomWoodToItemListing::emeralds), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_trades", (Object)16).forGetter(RandomWoodToItemListing::maxTrades), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("xp").forGetter(w -> Optional.of(w.xp)), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(RandomWoodToItemListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(RandomWoodToItemListing::level), (App)WoodTypeRegistry.INSTANCE.getCodec().listOf().optionalFieldOf("wood_blacklist", List.of()).forGetter(RandomWoodToItemListing::blacklist)).apply((Applicative)i, RandomWoodToItemListing::createDefault));

    private static RandomWoodToItemListing createDefault(boolean buys, String wood, int woodAmount, ItemCost emeralds, int maxTrades, Optional<Integer> xp, float priceMult, int level, List<WoodType> blacklist) {
        return new RandomWoodToItemListing(buys, wood, woodAmount, emeralds, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)buys, (int)level)), priceMult, level, blacklist);
    }

    public boolean isValid() {
        return VanillaWoodTypes.OAK.getItemOfThis(this.childKey) != null;
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource random) {
        WoodType type = null;
        ArrayList types = new ArrayList(WoodTypeRegistry.INSTANCE.getValues());
        int tries = 0;
        while (tries < 50 && !types.isEmpty()) {
            ++tries;
            if (type == null) {
                type = (WoodType)types.get(random.nextInt(types.size()));
            }
            types.remove(type);
            if (this.blacklist.contains(type)) {
                type = null;
                continue;
            }
            Item woodItem = type.getItemOfThis(this.childKey);
            if (woodItem == null || woodItem == Items.AIR) continue;
            ItemCost itemCost = new ItemCost((ItemLike)woodItem, this.woodPrice);
            ItemCost emerald = this.emeralds;
            if (this.buys) {
                return new MerchantOffer(itemCost, Optional.empty(), emerald.itemStack(), this.maxTrades, this.xp, this.priceMult);
            }
            return new MerchantOffer(emerald, Optional.empty(), itemCost.itemStack(), this.maxTrades, this.xp, this.priceMult);
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }
}

