/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.sawmill.trades.BiomeToWoodList;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record LogStrippingListing(ItemCost price, int amount, int maxTrades, int xp, float priceMult, int level, BiomeToWoodList biomeWoods) implements ModItemListing
{
    public static final MapCodec<LogStrippingListing> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ItemCost.CODEC.fieldOf("price").forGetter(LogStrippingListing::price), (App)Codec.INT.fieldOf("amount").forGetter(LogStrippingListing::amount), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_trades", (Object)16).forGetter(LogStrippingListing::maxTrades), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("xp").forGetter(w -> Optional.of(w.xp)), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(LogStrippingListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(LogStrippingListing::level), (App)BiomeToWoodList.CODEC.optionalFieldOf("biome_woods", (Object)new BiomeToWoodList(Map.of())).forGetter(LogStrippingListing::biomeWoods)).apply((Applicative)i, LogStrippingListing::createDefault));

    private static LogStrippingListing createDefault(ItemCost price, int amount, int maxTrades, Optional<Integer> xp, float priceMult, int level, @Nullable BiomeToWoodList biomeWoods) {
        return new LogStrippingListing(price, amount, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)false, (int)level)), priceMult, level, biomeWoods);
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    private WoodType getTypeSpecificWoodType(Entity trader, RandomSource random) {
        if (trader instanceof VillagerDataHolder) {
            VillagerDataHolder d = (VillagerDataHolder)trader;
            List<WoodType> list = this.biomeWoods.getWoodsForType(d.getVillagerData().getType());
            return list.get(random.nextInt(list.size()));
        }
        return null;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource random) {
        WoodType type = this.getTypeSpecificWoodType(trader, random);
        if (type == null) {
            return null;
        }
        Item log = type.log.asItem();
        Item stripped = type.getItemOfThis("stripped_log");
        if (stripped != null) {
            return new MerchantOffer(new ItemCost((ItemLike)log, this.amount), Optional.of(this.price), new ItemStack((ItemLike)stripped, this.amount), this.maxTrades, this.xp, this.priceMult);
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }
}

