/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.loot.BiomeTagPredicate;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class AquaBiomeModifiers {
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS_DEFERRED = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"aquaculture");

    public record FishSpawnBiomeModifier(List<HolderSet<Biome>> includeBiomes, List<HolderSet<Biome>> excludeBiomes, boolean and, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        public void modify(@Nonnull Holder<Biome> biome, @Nonnull BiomeModifier.Phase phase, @Nonnull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                if (biome.tags().noneMatch(BiomeTagPredicate.INVALID_TYPES::contains)) {
                    if (((HolderSet)this.includeBiomes.stream().findAny().get()).stream().findAny().isEmpty() && !this.excludeBiomes.isEmpty()) {
                        for (HolderSet<Biome> exclude : this.excludeBiomes) {
                            if (!exclude.contains(biome)) continue;
                            return;
                        }
                        this.debugOutput(biome, "Exclude only. Valid biome included");
                        builder.getMobSpawnSettings().addSpawn(this.spawn.type.getCategory(), this.spawn);
                    } else if (this.and) {
                        for (HolderSet<Biome> include : this.includeBiomes) {
                            if (include.contains(biome)) continue;
                            return;
                        }
                        this.debugOutput(biome, "And Include");
                        builder.getMobSpawnSettings().addSpawn(this.spawn.type.getCategory(), this.spawn);
                    } else {
                        for (HolderSet<Biome> exclude : this.excludeBiomes) {
                            if (!exclude.contains(biome)) continue;
                            return;
                        }
                        for (HolderSet<Biome> include : this.includeBiomes) {
                            if (!include.contains(biome)) continue;
                            this.debugOutput(biome, "Normal");
                            builder.getMobSpawnSettings().addSpawn(this.spawn.type.getCategory(), this.spawn);
                        }
                    }
                }
            }
        }

        private void debugOutput(Holder<Biome> biomeHolder, String s) {
            if (((Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get()).booleanValue()) {
                Aquaculture.LOG.info("Fish: " + String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.spawn.type)) + " | " + s + ": " + String.valueOf(((ResourceKey)biomeHolder.unwrapKey().get()).location()));
            }
        }

        @Nonnull
        public MapCodec<? extends BiomeModifier> codec() {
            return FishSpawnBiomeModifier.makeCodec();
        }

        public static MapCodec<FishSpawnBiomeModifier> makeCodec() {
            return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.listOf().fieldOf("includeBiomes").forGetter(FishSpawnBiomeModifier::includeBiomes), (App)Biome.LIST_CODEC.listOf().fieldOf("excludeBiomes").forGetter(FishSpawnBiomeModifier::excludeBiomes), (App)Codec.BOOL.fieldOf("and").forGetter(FishSpawnBiomeModifier::and), (App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("spawn").forGetter(FishSpawnBiomeModifier::spawn)).apply((Applicative)builder, FishSpawnBiomeModifier::new));
        }
    }

    public record MobSpawnBiomeModifier(HolderSet<Biome> includeList, HolderSet<Biome> excludeList, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        public void modify(@Nonnull Holder<Biome> biome, @Nonnull BiomeModifier.Phase phase, @Nonnull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.includeList.contains(biome) && !this.excludeList.contains(biome)) {
                builder.getMobSpawnSettings().addSpawn(this.spawn.type.getCategory(), this.spawn);
            }
        }

        @Nonnull
        public MapCodec<? extends BiomeModifier> codec() {
            return MobSpawnBiomeModifier.makeCodec();
        }

        public static MapCodec<MobSpawnBiomeModifier> makeCodec() {
            return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("includeBiomes").forGetter(MobSpawnBiomeModifier::includeList), (App)Biome.LIST_CODEC.fieldOf("excludeBiomes").forGetter(MobSpawnBiomeModifier::excludeList), (App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("spawn").forGetter(MobSpawnBiomeModifier::spawn)).apply((Applicative)builder, MobSpawnBiomeModifier::new));
        }
    }
}

