/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class LootBoxItem
extends Item {
    private final ResourceKey<LootTable> lootTable;

    public LootBoxItem(ResourceKey<LootTable> lootTable) {
        super(new Item.Properties());
        this.lootTable = lootTable;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (world.isClientSide || this.lootTable == null) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldStack);
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            LootParams.Builder builder = new LootParams.Builder(serverLevel);
            ObjectArrayList loot = serverLevel.getServer().reloadableRegistries().getLootTable(this.lootTable).getRandomItems(builder.create(LootContextParamSets.EMPTY));
            if (!loot.isEmpty()) {
                ItemStack lootStack = (ItemStack)loot.getFirst();
                player.displayClientMessage((Component)Component.translatable((String)"aquaculture.loot.open", (Object[])new Object[]{lootStack.getHoverName()}).withStyle(ChatFormatting.YELLOW), true);
                this.giveItem(player, lootStack);
                heldStack.shrink(1);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldStack);
            }
        }
        return super.use(world, player, hand);
    }

    private void giveItem(Player player, @Nonnull ItemStack stack) {
        if (!player.getInventory().add(stack)) {
            player.drop(stack, false);
        } else if (player instanceof ServerPlayer) {
            player.inventoryMenu.sendAllDataToRemote();
        }
    }
}

