/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.track.outfitted.ReversibleOutfittedTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.ReversiblePoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GatedTrackBlock
extends ReversiblePoweredOutfittedTrackBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty IN_WALL = BlockStateProperties.IN_WALL;
    public static final BooleanProperty ONE_WAY = BooleanProperty.create((String)"one_way");
    private static final double MOTION_MIN = 0.2;
    protected static final VoxelShape Z_SHAPE = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape X_SHAPE = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z_SHAPE_LOW = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
    protected static final VoxelShape X_SHAPE_LOW = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)13.0, (double)16.0);
    protected static final VoxelShape Z_COLLISION_SHAPE = GatedTrackBlock.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0);
    protected static final VoxelShape X_COLLISION_SHAPE = GatedTrackBlock.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)24.0, (double)16.0);
    protected static final VoxelShape Z_OCCLUSION_SHAPE = Shapes.or((VoxelShape)GatedTrackBlock.box((double)0.0, (double)5.0, (double)7.0, (double)2.0, (double)16.0, (double)9.0), (VoxelShape)GatedTrackBlock.box((double)14.0, (double)5.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0));
    protected static final VoxelShape X_OCCLUSION_SHAPE = Shapes.or((VoxelShape)GatedTrackBlock.box((double)7.0, (double)5.0, (double)0.0, (double)9.0, (double)16.0, (double)2.0), (VoxelShape)GatedTrackBlock.box((double)7.0, (double)5.0, (double)14.0, (double)9.0, (double)16.0, (double)16.0));
    protected static final VoxelShape Z_OCCLUSION_SHAPE_LOW = Shapes.or((VoxelShape)GatedTrackBlock.box((double)0.0, (double)2.0, (double)7.0, (double)2.0, (double)13.0, (double)9.0), (VoxelShape)GatedTrackBlock.box((double)14.0, (double)2.0, (double)7.0, (double)16.0, (double)13.0, (double)9.0));
    protected static final VoxelShape X_OCCLUSION_SHAPE_LOW = Shapes.or((VoxelShape)GatedTrackBlock.box((double)7.0, (double)2.0, (double)0.0, (double)9.0, (double)13.0, (double)2.0), (VoxelShape)GatedTrackBlock.box((double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)13.0, (double)16.0));

    public GatedTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)((BlockState)((BlockState)super.buildDefaultState(blockState).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(false))).setValue((Property)ONE_WAY, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPEN, IN_WALL, ONE_WAY});
    }

    @Override
    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)blockState.getValue((Property)IN_WALL)).booleanValue()) {
            return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.EAST_WEST ? X_SHAPE_LOW : Z_SHAPE_LOW;
        }
        return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.EAST_WEST ? X_SHAPE : Z_SHAPE;
    }

    public BlockState updateShape(BlockState blockState, Direction neighborDirection, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (ReversibleOutfittedTrackBlock.getFacing(blockState).getClockWise().getAxis() != neighborDirection.getAxis()) {
            return super.updateShape(blockState, neighborDirection, neighborState, level, pos, neighborPos);
        }
        return (BlockState)blockState.setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(this.isWall(neighborState) || this.isWall(level.getBlockState(pos.relative(neighborDirection.getOpposite())))));
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)blockState.getValue((Property)OPEN)).booleanValue()) {
            return Shapes.empty();
        }
        return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.NORTH_SOUTH ? Z_COLLISION_SHAPE : X_COLLISION_SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState blockState, BlockGetter level, BlockPos pos) {
        if (((Boolean)blockState.getValue((Property)IN_WALL)).booleanValue()) {
            return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.EAST_WEST ? X_OCCLUSION_SHAPE_LOW : Z_OCCLUSION_SHAPE_LOW;
        }
        return GatedTrackBlock.getRailShapeRaw(blockState) == RailShape.EAST_WEST ? X_OCCLUSION_SHAPE : Z_OCCLUSION_SHAPE;
    }

    public boolean isPathfindable(BlockState blockState, PathComputationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)blockState.getValue((Property)OPEN);
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        RailShape railShape = GatedTrackBlock.getRailShapeRaw(blockState);
        boolean inWall = railShape == RailShape.NORTH_SOUTH && (this.isWall(level.getBlockState(pos.west())) || this.isWall(level.getBlockState(pos.east()))) || railShape == RailShape.EAST_WEST && (this.isWall(level.getBlockState(pos.north())) || this.isWall(level.getBlockState(pos.south())));
        return (BlockState)((BlockState)blockState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(GatedTrackBlock.isPowered(blockState)))).setValue((Property)IN_WALL, (Comparable)Boolean.valueOf(inWall));
    }

    private boolean isWall(BlockState blockState) {
        return blockState.is(BlockTags.WALLS);
    }

    @Override
    public int getPowerPropagation(BlockState blockState, Level level, BlockPos pos) {
        return 0;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        if (GatedTrackBlock.isOneWay(blockState) && GatedTrackBlock.isOpen(blockState)) {
            RailShape shape = GatedTrackBlock.getRailShapeRaw(blockState);
            Vec3 deltaMovement = cart.getDeltaMovement();
            if (shape == RailShape.NORTH_SOUTH) {
                double motion = Math.max(Math.abs(deltaMovement.z()), 0.2);
                cart.setDeltaMovement(deltaMovement.x(), deltaMovement.y(), motion * (GatedTrackBlock.isReversed(blockState) ? 1.0 : -1.0));
            } else {
                double motion = Math.max(Math.abs(deltaMovement.x()), 0.2);
                cart.setDeltaMovement(motion * (GatedTrackBlock.isReversed(blockState) ? -1.0 : 1.0), deltaMovement.y(), deltaMovement.z());
            }
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemInteractionResult result = super.useItemOn(itemStack, state, level, pos, player, hand, rayTraceResult);
        if (result.consumesAction()) {
            return result;
        }
        if (!level.isClientSide()) {
            boolean open = !GatedTrackBlock.isOpen(state);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)));
            level.playSound(null, pos, open ? SoundEvents.FENCE_GATE_OPEN : SoundEvents.FENCE_GATE_CLOSE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Override
    public boolean crowbarWhack(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        int newState = ((GatedTrackBlock.isOneWay(blockState) ? 2 : 0) | (GatedTrackBlock.isReversed(blockState) ? 1 : 0)) + (player.isShiftKeyDown() ? 3 : 1);
        return level.setBlockAndUpdate(pos, (BlockState)((BlockState)blockState.setValue((Property)ONE_WAY, (Comparable)Boolean.valueOf((newState & 2) == 2))).setValue((Property)REVERSED, (Comparable)Boolean.valueOf((newState & 1) == 1)));
    }

    @Override
    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        boolean powered;
        super.neighborChanged(blockState, level, pos, neighborBlock, neighborPos, moved);
        if (!level.isClientSide() && (powered = GatedTrackBlock.isPowered(blockState)) != GatedTrackBlock.isOpen(blockState)) {
            level.setBlock(pos, (BlockState)blockState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(powered)), 2);
            level.playSound(null, pos, powered ? SoundEvents.FENCE_GATE_OPEN : SoundEvents.FENCE_GATE_CLOSE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        }
    }

    public static boolean isOpen(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)OPEN);
    }

    public static boolean isOneWay(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)ONE_WAY);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.translatable((String)Translations.Tips.GATED_TRACK).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_MODE).withStyle(ChatFormatting.BLUE));
        lines.add((Component)Component.translatable((String)Translations.Tips.APPLY_REDSTONE_TO_OPEN).withStyle(ChatFormatting.RED));
    }
}

