/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.api.carts.Routable;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ForwardingContainer;
import mods.railcraft.world.inventory.RoutingTrackMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.LockableTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RoutingTrackBlockEntity
extends LockableTrackBlockEntity
implements ForwardingContainer,
MenuProvider {
    private final AdvancedContainer container = new AdvancedContainer(1).listener(this);

    public RoutingTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.ROUTING_TRACK.get(), blockPos, blockState);
    }

    public void minecartPassed(AbstractMinecart cart) {
        ItemStack stack;
        if (PoweredOutfittedTrackBlock.isPowered(this.getBlockState()) && !(stack = this.container.getItem(0)).isEmpty() && cart instanceof Routable) {
            Routable routable = (Routable)cart;
            routable.setDestination(stack);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("container", (Tag)this.container.createTag(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.container.fromTag(tag.getList("container", 10), provider);
    }

    @Override
    public Container container() {
        return this.container;
    }

    @Override
    public boolean stillValid(Player player) {
        return this.isStillValid(player);
    }

    @Override
    public Component getName() {
        return this.getDisplayName();
    }

    @Override
    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new RoutingTrackMenu(id, inventory, this);
    }
}

