/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.world.level.block.ForceTrackEmitterBlock;
import mods.railcraft.world.level.block.entity.ForceTrackEmitterBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.track.ForceTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class ForceTrackBlockEntity
extends RailcraftBlockEntity {
    @Nullable
    private ForceTrackEmitterBlockEntity emitter;
    @Nullable
    private BlockPos emitterPos;

    public ForceTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK.get(), blockPos, blockState);
    }

    public void blockRemoved() {
        this.emitter.clearTracks(this.getBlockPos());
    }

    public void neighborChanged() {
        this.emitter.notifyTrackChange();
    }

    public void setEmitter(ForceTrackEmitterBlockEntity emitter) {
        this.emitter = emitter;
        this.emitterPos = emitter.getBlockPos();
        this.setOwner(emitter.getOwner().orElse(null));
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(ForceTrackBlock.COLOR, (Comparable)((DyeColor)emitter.getBlockState().getValue(ForceTrackEmitterBlock.COLOR))));
    }

    public void onLoad() {
        super.onLoad();
        this.emitter = this.emitterPos == null ? null : (ForceTrackEmitterBlockEntity)this.level.getBlockEntity(this.emitterPos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).orElse(null);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.emitterPos != null) {
            tag.put("emitterPos", NbtUtils.writeBlockPos((BlockPos)this.emitterPos));
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("emitterPos")) {
            this.emitterPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"emitterPos").orElse(null);
        }
    }
}

