/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.enchantment;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.tags.RailcraftTags;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;

public class RailcraftEnchantments {
    public static final ResourceKey<Enchantment> WRECKING = RailcraftEnchantments.createKey("wrecking");
    public static final ResourceKey<Enchantment> IMPLOSION = RailcraftEnchantments.createKey("implosion");
    public static final ResourceKey<Enchantment> DESTRUCTION = RailcraftEnchantments.createKey("destruction");
    public static final ResourceKey<Enchantment> SMACK = RailcraftEnchantments.createKey("smack");

    private static ResourceKey<Enchantment> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)RailcraftConstants.rl(name));
    }

    private static void register(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> enchantment, Enchantment.Builder builder) {
        context.register(enchantment, (Object)builder.build(enchantment.location()));
    }

    private static Enchantment.Builder customDamageEnchantment(HolderGetter<Item> items, int baseEnchantability, int levelEnchantability, int thresholdEnchantability) {
        return Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(RailcraftTags.Items.ENCHANTMENTS), (int)1, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)baseEnchantability, (int)levelEnchantability), (Enchantment.Cost)Enchantment.dynamicCost((int)(baseEnchantability + thresholdEnchantability), (int)levelEnchantability), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND}));
    }

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        RailcraftEnchantments.register(context, WRECKING, RailcraftEnchantments.customDamageEnchantment((HolderGetter<Item>)items, 1, 11, 20));
        RailcraftEnchantments.register(context, IMPLOSION, RailcraftEnchantments.customDamageEnchantment((HolderGetter<Item>)items, 5, 8, 20).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)2.5f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of((EntityType)EntityType.CREEPER)))));
        RailcraftEnchantments.register(context, DESTRUCTION, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(RailcraftTags.Items.CROWBAR), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)10), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        RailcraftEnchantments.register(context, SMACK, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(RailcraftTags.Items.CROWBAR), (int)1, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)9, (int)8), (Enchantment.Cost)Enchantment.dynamicCost((int)29, (int)8), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
    }
}

