/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.material.RailcraftFluids;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class CokeOvenRecipe
extends AbstractCookingRecipe {
    private final FluidStack creosote;

    public CokeOvenRecipe(Ingredient ingredient, ItemStack result, float experience, int cookingTime, int creosoteOutput) {
        super((RecipeType)RailcraftRecipeTypes.COKING.get(), "", CookingBookCategory.MISC, ingredient, result, experience, cookingTime);
        this.creosote = new FluidStack((Fluid)RailcraftFluids.CREOSOTE.get(), creosoteOutput);
    }

    public FluidStack getCreosote() {
        return this.creosote;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RailcraftRecipeSerializers.COKING.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)RailcraftBlocks.COKE_OVEN_BRICKS.get());
    }

    public static class Serializer
    implements RecipeSerializer<CokeOvenRecipe> {
        private static final MapCodec<CokeOvenRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> ((CokeOvenRecipe)recipe).ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> ((CokeOvenRecipe)recipe).result), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(((CokeOvenRecipe)recipe).experience)), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("cookingTime", (Object)400).forGetter(recipe -> ((CokeOvenRecipe)recipe).cookingTime), (App)ExtraCodecs.POSITIVE_INT.fieldOf("creosoteOutput").forGetter(recipe -> recipe.creosote.getAmount())).apply((Applicative)instance, CokeOvenRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, CokeOvenRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CokeOvenRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CokeOvenRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static CokeOvenRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int creosoteOutput = buffer.readVarInt();
            int cookingTime = buffer.readVarInt();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            float experience = buffer.readFloat();
            return new CokeOvenRecipe(ingredient, result, experience, cookingTime, creosoteOutput);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, CokeOvenRecipe recipe) {
            buffer.writeVarInt(recipe.creosote.getAmount());
            buffer.writeVarInt(recipe.cookingTime);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeFloat(recipe.experience);
        }
    }
}

