/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.function.Predicate;
import mods.railcraft.client.ScreenFactories;
import mods.railcraft.world.item.TicketItem;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.TicketComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GoldenTicketItem
extends TicketItem {
    public static final Predicate<ItemStack> FILTER = stack -> stack != null && stack.getItem() instanceof GoldenTicketItem;

    public GoldenTicketItem(Item.Properties properties) {
        super(properties);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack newItemStack = new ItemStack((ItemLike)this);
        if (itemStack.has(RailcraftDataComponents.TICKET)) {
            newItemStack.set(RailcraftDataComponents.TICKET, (Object)((TicketComponent)itemStack.get(RailcraftDataComponents.TICKET)));
        }
        return newItemStack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (level.isClientSide()) {
            ScreenFactories.openGoldenTicketScreen(itemStack, usedHand);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }
}

