/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import mods.railcraft.api.item.MinecartFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;

public class CartItem
extends Item {
    private final MinecartFactory minecartFactory;

    public CartItem(MinecartFactory minecartFactory, Item.Properties properties) {
        super(properties);
        this.minecartFactory = minecartFactory;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos railPos;
        Level level = context.getLevel();
        if (!BaseRailBlock.isRail((Level)level, (BlockPos)(railPos = context.getClickedPos()))) {
            return InteractionResult.FAIL;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Player player = context.getPlayer();
            BlockState railState = level.getBlockState(railPos);
            ItemStack itemStack = player.getItemInHand(context.getHand());
            RailShape railShape = RailShape.NORTH_SOUTH;
            Block block = railState.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock baseRailBlock = (BaseRailBlock)block;
                railShape = baseRailBlock.getRailDirection(railState, (BlockGetter)level, railPos, null);
            }
            double d0 = railShape.isAscending() ? 0.5 : 0.0;
            AbstractMinecart minecart = this.minecartFactory.createMinecart(itemStack, (double)railPos.getX() + 0.5, (double)railPos.getY() + d0 + 0.0625, (double)railPos.getZ() + 0.5, serverLevel);
            if (minecart != null) {
                minecart.setYRot(context.getHorizontalDirection().toYRot());
                level.addFreshEntity((Entity)minecart);
                level.gameEvent((Holder)GameEvent.ENTITY_PLACE, railPos, GameEvent.Context.of((Entity)player, (BlockState)level.getBlockState(railPos.below())));
                itemStack.shrink(1);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public MinecartFactory getMinecartFactory() {
        return this.minecartFactory;
    }
}

