/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.fluids;

import java.util.stream.IntStream;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class AdvancedFluidHandler
implements IFluidHandler {
    private final IFluidHandler fluidHandler;

    public AdvancedFluidHandler(IFluidHandler fluidHandler) {
        this.fluidHandler = fluidHandler;
    }

    public int getTanks() {
        return this.fluidHandler.getTanks();
    }

    public FluidStack getFluidInTank(int i) {
        return this.fluidHandler.getFluidInTank(i);
    }

    public int getTankCapacity(int i) {
        return this.fluidHandler.getTankCapacity(i);
    }

    public boolean isFluidValid(int i, FluidStack fluidStack) {
        return this.fluidHandler.isFluidValid(i, fluidStack);
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return this.fluidHandler.fill(fluidStack, fluidAction);
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return this.fluidHandler.drain(fluidStack, fluidAction);
    }

    public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        return this.fluidHandler.drain(i, fluidAction);
    }

    public int getFluidQty(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return 0;
        }
        return IntStream.range(0, this.getTanks()).mapToObj(this::getFluidInTank).filter(fluidStack -> FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)fluid)).mapToInt(FluidStack::getAmount).sum();
    }

    public boolean isTankEmpty(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return this.areTanksEmpty();
        }
        return this.getFluidQty(fluid) <= 0;
    }

    public boolean isTankFull(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return this.areTanksFull();
        }
        int fill = this.fill(fluid.copyWithAmount(1), IFluidHandler.FluidAction.SIMULATE);
        return fill <= 0;
    }

    public boolean areTanksFull() {
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack tank = this.getFluidInTank(i);
            if (!tank.isEmpty() && tank.getAmount() >= this.getTankCapacity(i)) continue;
            return false;
        }
        return true;
    }

    public boolean areTanksEmpty() {
        return !this.isFluidInTank();
    }

    public boolean isFluidInTank() {
        for (int i = 0; i < this.getTanks(); ++i) {
            boolean empty;
            FluidStack tank = this.getFluidInTank(i);
            boolean bl = empty = tank.isEmpty() || tank.getAmount() <= 0;
            if (empty) continue;
            return true;
        }
        return false;
    }

    public float getFluidLevel() {
        int amount = 0;
        int capacity = 0;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack liquid = this.getFluidInTank(i);
            amount += liquid.isEmpty() ? 0 : liquid.getAmount();
            capacity += this.getTankCapacity(i);
        }
        return capacity == 0 ? 0.0f : (float)amount / (float)capacity;
    }

    public float getFluidLevel(FluidStack fluid) {
        int amount = 0;
        int capacity = 0;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack liquid = this.getFluidInTank(i);
            if (liquid.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)liquid, (FluidStack)fluid)) continue;
            amount += liquid.getAmount();
            capacity += this.getTankCapacity(i);
        }
        return capacity == 0 ? 0.0f : (float)amount / (float)capacity;
    }

    public boolean canPutFluid(FluidStack fluid) {
        return !fluid.isEmpty() && this.fill(fluid, IFluidHandler.FluidAction.SIMULATE) > 0;
    }
}

