/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.loot.RailcraftLootModifiers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class DungeonLootModifier
extends LootModifier {
    public static final MapCodec<DungeonLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> DungeonLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("lootTable").forGetter(m -> m.lootTable)).apply((Applicative)inst, DungeonLootModifier::new));
    private final ResourceKey<LootTable> lootTable;

    public DungeonLootModifier(LootItemCondition[] conditionsIn, ResourceKey<LootTable> lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)RailcraftConfig.SERVER.changeDungeonLoot.get()).booleanValue()) {
            context.getResolver().get(Registries.LOOT_TABLE, this.lootTable).ifPresent(extraTable -> ((LootTable)extraTable.value()).getRandomItemsRaw(context, LootTable.createStackSplitter((ServerLevel)context.getLevel(), arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0))));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return RailcraftLootModifiers.DUNGEON_LOOT_MODIFIER.get();
    }
}

