/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.emi.RailcraftEmiPlugin;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.BlastFurnaceRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class BlastFurnaceEmiRecipe
extends BasicEmiRecipe {
    private static final int WIDTH = 82;
    private static final int HEIGHT = 54;
    private static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/blast_furnace.png");
    private final BlastFurnaceRecipe recipe;

    public BlastFurnaceEmiRecipe(RecipeHolder<BlastFurnaceRecipe> recipe) {
        super(RailcraftEmiPlugin.BLASTING_CATEGORY, recipe.id(), 82, 54);
        this.recipe = (BlastFurnaceRecipe)recipe.value();
        this.inputs.add(EmiIngredient.of((Ingredient)((Ingredient)this.recipe.getIngredients().getFirst())));
        ClientLevel level = Minecraft.getInstance().level;
        this.outputs.add(EmiStack.of((ItemStack)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess())));
        if (this.recipe.getSlagOutput() > 0) {
            this.outputs.add(EmiStack.of((ItemStack)new ItemStack((ItemLike)RailcraftItems.SLAG.get(), this.recipe.getSlagOutput())));
        }
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, this.width, this.height, 55, 16);
        widgets.addFillingArrow(24, 18, 10000).tooltip((x, y) -> {
            int cookTime = this.recipe.getCookingTime();
            if (cookTime > 0) {
                int cookTimeSeconds = cookTime / 20;
                MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
                return List.of(EmiTooltipComponents.of((Component)timeString));
            }
            return List.of(EmiTooltipComponents.of((Component)Component.empty()));
        });
        widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 1, 20, 10000, false, true, true);
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 0, 0);
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 56, 0).large(true).recipeContext((EmiRecipe)this);
        if (this.outputs.size() > 1) {
            widgets.addSlot((EmiIngredient)this.outputs.get(1), 60, 36).recipeContext((EmiRecipe)this);
        }
    }
}

