/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.RitualBlock;
import mods.railcraft.world.level.block.entity.RitualBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.Property;

public class RitualBlockRenderer
implements BlockEntityRenderer<RitualBlockEntity> {
    private final ItemRenderer itemRenderer;

    public RitualBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(RitualBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        float yOffset = blockEntity.getYOffset(partialTick);
        poseStack.translate(0.5f, 0.95f + yOffset, 0.5f);
        float yaw = blockEntity.getRotationYaw(partialTick);
        poseStack.mulPose(Axis.YP.rotation(yaw));
        poseStack.scale(0.6f, 0.6f, 0.6f);
        ItemStack firestone = new ItemStack((Boolean)blockEntity.getBlockState().getValue((Property)RitualBlock.CRACKED) != false ? (ItemLike)RailcraftItems.CRACKED_FIRESTONE.get() : (ItemLike)RailcraftItems.REFINED_FIRESTONE.get());
        int id = (int)blockEntity.getBlockPos().asLong();
        this.itemRenderer.renderStatic(firestone, ItemDisplayContext.NONE, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.level(), id);
        poseStack.popPose();
    }
}

