/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particle;

import mods.railcraft.client.particle.BaseSmokeParticle;
import mods.railcraft.particle.ChimneyParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ChimneyParticle
extends BaseSmokeParticle {
    public ChimneyParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, int color, SpriteSet sprites) {
        this(level, x, y, z, dx, dy, dz, 3.0f, color, sprites);
    }

    public ChimneyParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, float scale, int color, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz, scale);
        this.gravity = -0.1f;
        this.rCol = Mth.clamp((float)(this.random.nextFloat() * 0.1f - 0.05f + (float)FastColor.ARGB32.red((int)color) / 255.0f), (float)0.0f, (float)1.0f);
        this.gCol = Mth.clamp((float)(this.random.nextFloat() * 0.1f - 0.05f + (float)FastColor.ARGB32.green((int)color) / 255.0f), (float)0.0f, (float)1.0f);
        this.bCol = Mth.clamp((float)(this.random.nextFloat() * 0.1f - 0.05f + (float)FastColor.ARGB32.blue((int)color) / 255.0f), (float)0.0f, (float)1.0f);
        this.lifetime = (int)(24.0f / (this.random.nextFloat() * 0.5f + 0.2f) * scale);
        this.pickSprite(sprites);
    }

    public static class Provider
    implements ParticleProvider<ChimneyParticleOptions> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(ChimneyParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ChimneyParticle(level, x, y, z, dx, dy, dz, options.color(), this.spriteSet);
        }
    }
}

