/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.model;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mods.railcraft.client.model.CubeModel;
import mods.railcraft.client.model.DeformableMinecartModel;
import mods.railcraft.client.model.ElectricLocomotiveLampModel;
import mods.railcraft.client.model.ElectricLocomotiveModel;
import mods.railcraft.client.model.LowSidesMinecartModel;
import mods.railcraft.client.model.MaintenanceLampModel;
import mods.railcraft.client.model.MaintenanceModel;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.model.SteamLocomotiveModel;
import mods.railcraft.client.model.TunnelBoreModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;

public class RailcraftLayerDefinitions {
    private static final CubeDeformation SNOW_DEFORMATION = new CubeDeformation(0.125f);

    public static void createRoots(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> consumer) {
        consumer.accept(RailcraftModelLayers.ELECTRIC_LOCOMOTIVE, () -> ElectricLocomotiveModel.createBodyLayer(CubeDeformation.NONE));
        consumer.accept(RailcraftModelLayers.ELECTRIC_LOCOMOTIVE_SNOW, () -> ElectricLocomotiveModel.createBodyLayer(SNOW_DEFORMATION));
        consumer.accept(RailcraftModelLayers.STEAM_LOCOMOTIVE, () -> SteamLocomotiveModel.createBodyLayer(CubeDeformation.NONE));
        consumer.accept(RailcraftModelLayers.STEAM_LOCOMOTIVE_SNOW, () -> SteamLocomotiveModel.createBodyLayer(SNOW_DEFORMATION));
        consumer.accept(RailcraftModelLayers.LOW_SIDES_MINECART, () -> LowSidesMinecartModel.createBodyLayer(CubeDeformation.NONE));
        consumer.accept(RailcraftModelLayers.LOW_SIDES_MINECART_SNOW, () -> LowSidesMinecartModel.createBodyLayer(SNOW_DEFORMATION));
        consumer.accept(RailcraftModelLayers.ELECTRIC_LOCOMOTIVE_LAMP, ElectricLocomotiveLampModel::createBodyLayer);
        consumer.accept(RailcraftModelLayers.MAINTENANCE_LAMP, MaintenanceLampModel::createBodyLayer);
        consumer.accept(RailcraftModelLayers.MAINTENANCE, MaintenanceModel::createBodyLayer);
        consumer.accept(RailcraftModelLayers.TUNNEL_BORE, TunnelBoreModel::createBodyLayer);
        consumer.accept(RailcraftModelLayers.MINECART_SNOW, () -> DeformableMinecartModel.createBodyLayer(SNOW_DEFORMATION));
        consumer.accept(RailcraftModelLayers.CUBE, CubeModel::createBodyLayer);
    }
}

