/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.util.StorageUtil;
import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class MessageSetRecipe
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"set_recipe");
    public static final CustomPacketPayload.Type<MessageSetRecipe> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetRecipe> STREAM_CODEC = CustomPacketPayload.codec(MessageSetRecipe::encode, MessageSetRecipe::new);
    private CompoundTag nbt;
    private int index = 0;

    public MessageSetRecipe(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetRecipe(CompoundTag nbt) {
        this.nbt = nbt;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof IStorageControllerContainer)) {
            return;
        }
        IStorageControllerContainer container = (IStorageControllerContainer)abstractContainerMenu;
        IStorageController storageController = container.getStorageController();
        if (storageController == null) {
            return;
        }
        StorageUtil.clearOpenCraftingMatrix(player, false);
        CraftingContainer craftMatrix = container.getCraftMatrix();
        block0: for (int slot = 0; slot < 9; ++slot) {
            int i;
            HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
            ListTag invList = this.nbt.getList("s" + slot, 10);
            for (i = 0; i < invList.size(); ++i) {
                ItemStack s = ItemStack.parseOptional((HolderLookup.Provider)minecraftServer.registryAccess(), (CompoundTag)invList.getCompound(i));
                map.put(i, s);
            }
            for (i = 0; i < map.size(); ++i) {
                ItemStack stack = (ItemStack)map.get(i);
                if (stack == null || stack.isEmpty()) continue;
                ItemStackComparator comparator = new ItemStackComparator(stack, true);
                ItemStack extractedStack = StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), comparator, 1, true);
                if (extractedStack != null && !extractedStack.isEmpty() && craftMatrix.getItem(slot).isEmpty()) {
                    StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), comparator, 1, false);
                    craftMatrix.setItem(slot, extractedStack);
                    continue block0;
                }
                if ((stack = storageController.getItemStack(!stack.isEmpty() ? comparator : null, 1, false)).isEmpty() || !craftMatrix.getItem(slot).isEmpty()) continue;
                craftMatrix.setItem(slot, stack);
                continue block0;
            }
        }
        container.updateCraftingSlots(true);
        Networking.sendTo(player, storageController.getMessageUpdateStacks());
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.nbt);
        buf.writeInt(this.index);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.nbt = buf.readNbt();
        this.index = buf.readInt();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

