/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.util.StorageUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MessageRequestOrder
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"request_order");
    public static final CustomPacketPayload.Type<MessageRequestOrder> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageRequestOrder> STREAM_CODEC = CustomPacketPayload.codec(MessageRequestOrder::encode, MessageRequestOrder::new);
    private GlobalBlockPos storageControllerPosition;
    private GlobalBlockPos targetMachinePosition;
    private ItemStack stack = ItemStack.EMPTY;

    public MessageRequestOrder(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageRequestOrder(GlobalBlockPos storageControllerPosition, GlobalBlockPos targetMachinePosition, ItemStack stack) {
        this.storageControllerPosition = storageControllerPosition;
        this.targetMachinePosition = targetMachinePosition;
        this.stack = stack;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        ServerLevel level = minecraftServer.getLevel(this.storageControllerPosition.getDimensionKey());
        if (!level.hasChunkAt(this.storageControllerPosition.getPos())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.storageControllerPosition.getPos());
        if (!(blockEntity instanceof IStorageController)) {
            return;
        }
        IStorageController storageController = (IStorageController)blockEntity;
        StorageUtil.clearOpenOrderSlot(player, true);
        ItemStackComparator comparator = new ItemStackComparator(this.stack, true);
        storageController.addDepositOrder(this.targetMachinePosition, comparator, this.stack.getCount());
        player.displayClientMessage((Component)Component.translatable((String)"network.messages.occultism.request_order.order_received"), true);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        this.storageControllerPosition.encode((FriendlyByteBuf)buf);
        this.targetMachinePosition.encode((FriendlyByteBuf)buf);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.stack);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.storageControllerPosition = GlobalBlockPos.from(buf);
        this.targetMachinePosition = GlobalBlockPos.from(buf);
        this.stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

