/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.jei.impl.recipes;

import com.klikli_dev.occultism.crafting.recipe.SpiritTradeRecipe;
import com.klikli_dev.occultism.crafting.recipe.TraderRecipeInput;
import com.klikli_dev.occultism.integration.jei.impl.JeiRecipeTypes;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;

public class SpiritTradeRecipeCategory
implements IRecipeCategory<RecipeHolder<SpiritTradeRecipe>> {
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;

    public SpiritTradeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 44);
        this.localizedName = Component.translatable((String)"occultism.jei.spirit_trader");
        this.overlay = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    protected void drawStringCentered(GuiGraphics guiGraphics, Font font, Component text, int x, int y) {
        GuiGraphicsExt.drawString(guiGraphics, font, text, (float)x - (float)font.width((FormattedText)text) / 2.0f, (float)y, 0, false);
    }

    public RecipeType<RecipeHolder<SpiritTradeRecipe>> getRecipeType() {
        return JeiRecipeTypes.SPIRIT_TRADE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<SpiritTradeRecipe> recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 12).addIngredients((Ingredient)((SpiritTradeRecipe)recipe.value()).getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 12).addItemStack(((SpiritTradeRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }

    public void draw(RecipeHolder<SpiritTradeRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(guiGraphics, 76, 14);
        this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)("job." + ((SpiritTradeRecipe)recipe.value()).getTrader().replace(":", "."))), 84, 0);
        List recipes = Minecraft.getInstance().level.getRecipeManager().getRecipesFor((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.SPIRIT_TRADE_TYPE.get(), (RecipeInput)new TraderRecipeInput(((Ingredient)((SpiritTradeRecipe)recipe.value()).getIngredients().getFirst()).getItems()[0], ((SpiritTradeRecipe)recipe.value()).getTrader()), (Level)Minecraft.getInstance().level);
        AtomicInteger all = new AtomicInteger();
        recipes.forEach(rs -> all.addAndGet(((SpiritTradeRecipe)rs.value()).getWeightedResult().weight()));
        Float chances = Float.valueOf(100.0f * (float)((SpiritTradeRecipe)recipe.value()).getWeightedResult().weight() / (float)all.get());
        this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)"occultism.jei.spirit_trader.chance", (Object[])new Object[]{String.format(Locale.US, "%.2f", chances)}), 84, 33);
    }
}

