/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.emi.impl.recipes;

import com.klikli_dev.occultism.crafting.recipe.SpiritTradeRecipe;
import com.klikli_dev.occultism.crafting.recipe.TraderRecipeInput;
import com.klikli_dev.occultism.integration.emi.impl.OccultismEmiPlugin;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiritTraderRecipeCategory
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final float chances;
    private final Component trader;
    private static final List<EmiIngredient> tiers = List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_SAPLING_TRADER.get())})), EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_OTHERSTONE_TRADER.get())})), EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_OTHERROCK_TRADER.get())})));

    public SpiritTraderRecipeCategory(RecipeHolder<SpiritTradeRecipe> recipe) {
        this.id = recipe.id();
        this.input = List.of(EmiIngredient.of((Ingredient)((Ingredient)((SpiritTradeRecipe)recipe.value()).getIngredients().get(0))));
        this.output = List.of(EmiStack.of((ItemStack)((SpiritTradeRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        List recipes = Minecraft.getInstance().level.getRecipeManager().getRecipesFor((RecipeType)OccultismRecipes.SPIRIT_TRADE_TYPE.get(), (RecipeInput)new TraderRecipeInput(((Ingredient)((SpiritTradeRecipe)recipe.value()).getIngredients().getFirst()).getItems()[0], ((SpiritTradeRecipe)recipe.value()).getTrader()), (Level)Minecraft.getInstance().level);
        AtomicInteger all = new AtomicInteger();
        recipes.forEach(rs -> all.addAndGet(((SpiritTradeRecipe)rs.value()).getWeightedResult().weight()));
        this.chances = 100.0f * (float)((SpiritTradeRecipe)recipe.value()).getWeightedResult().weight() / (float)all.get();
        this.trader = Component.translatable((String)("job." + ((SpiritTradeRecipe)recipe.value()).getTrader().replace(":", ".")));
    }

    public EmiRecipeCategory getCategory() {
        return OccultismEmiPlugin.TRADER_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 134;
    }

    public int getDisplayHeight() {
        return 38;
    }

    public void addWidgets(@NotNull WidgetHolder widgetHolder) {
        widgetHolder.addText(this.trader, this.getDisplayWidth() / 2, 0, 0, false).horizontalAlign(TextWidget.Alignment.CENTER);
        widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, this.getDisplayWidth() / 2 - 12, 11);
        widgetHolder.addSlot(this.input.get(0), this.getDisplayWidth() / 2 - 32, 10);
        widgetHolder.addSlot((EmiIngredient)this.output.get(0), this.getDisplayWidth() / 2 + 16, 10).recipeContext((EmiRecipe)this);
        widgetHolder.addText((Component)Component.translatable((String)"occultism.jei.spirit_trader.chance", (Object[])new Object[]{String.format(Locale.US, "%.2f", Float.valueOf(this.chances))}), this.getDisplayWidth() / 2, this.getDisplayHeight() - 8, 0, false).horizontalAlign(TextWidget.Alignment.CENTER);
    }

    public List<EmiIngredient> getCatalysts() {
        return tiers;
    }
}

