/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.emi.impl.recipes;

import com.klikli_dev.occultism.common.entity.spirit.FoliotEntity;
import com.klikli_dev.occultism.crafting.recipe.CrystallizeRecipe;
import com.klikli_dev.occultism.integration.emi.impl.OccultismEmiPlugin;
import com.klikli_dev.occultism.integration.emi.impl.render.SpiritWidget;
import com.klikli_dev.occultism.registry.OccultismEntities;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CrystallizeRecipeCategory
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final Integer min;
    private final Integer max;
    private final Boolean multiplyOutput;
    private static final List<EmiIngredient> tiers = List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_marid_crystallizer")))})), EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_afrit_crystallizer")))})), EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_djinni_crystallizer")))})), EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual_dummy/summon_foliot_crystallizer")))})));

    public CrystallizeRecipeCategory(RecipeHolder<CrystallizeRecipe> recipe) {
        this.id = recipe.id();
        this.min = ((CrystallizeRecipe)recipe.value()).getMinTier();
        this.max = ((CrystallizeRecipe)recipe.value()).getMaxTier();
        this.multiplyOutput = !((CrystallizeRecipe)recipe.value()).getIgnoreCrystallizeMultiplier();
        this.input = List.of(EmiIngredient.of((Ingredient)((Ingredient)((CrystallizeRecipe)recipe.value()).getIngredients().get(0))));
        this.output = List.of(EmiStack.of((ItemStack)((CrystallizeRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
    }

    public EmiRecipeCategory getCategory() {
        return OccultismEmiPlugin.CRYSTALLIZE_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public Boolean getIfMultiplyOutput() {
        return this.multiplyOutput;
    }

    public int getDisplayWidth() {
        return 110;
    }

    public int getDisplayHeight() {
        return 30;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        Object spiritType;
        widgetHolder.addSlot(this.input.get(0), 0, 7);
        widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 18, 7);
        int y = 0;
        int s = 12;
        if (this.getMin() <= 1) {
            y = 10;
            s = 16;
            spiritType = OccultismEntities.FOLIOT.get();
        } else {
            spiritType = this.getMin() == 2 ? OccultismEntities.DJINNI.get() : (this.getMin() == 3 ? OccultismEntities.AFRIT.get() : OccultismEntities.MARID.get());
        }
        SpiritWidget widget = new SpiritWidget<FoliotEntity>(53, y, (EntityType<FoliotEntity>)spiritType, s).tooltip((mouseX, mouseY) -> {
            ArrayList<ClientTextTooltip> tooltip = new ArrayList<ClientTextTooltip>();
            if (this.getMin() >= 1) {
                tooltip.add(new ClientTextTooltip(Component.translatable((String)"jei.occultism.crystallize.min_tier", (Object[])new Object[]{this.getMin()}).getVisualOrderText()));
            }
            if (this.getMax() >= 1) {
                tooltip.add(new ClientTextTooltip(Component.translatable((String)"jei.occultism.crystallize.max_tier", (Object[])new Object[]{this.getMax()}).getVisualOrderText()));
            }
            if (this.getIfMultiplyOutput().booleanValue()) {
                tooltip.add(new ClientTextTooltip(Component.translatable((String)"jei.occultism.crystallize.multiply_output").getVisualOrderText()));
            }
            return tooltip;
        });
        widgetHolder.add((Widget)widget);
        widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 64, 7);
        widgetHolder.addSlot((EmiIngredient)this.output.get(0), 90, 7).recipeContext((EmiRecipe)this);
    }

    public List<EmiIngredient> getCatalysts() {
        return tiers;
    }
}

