/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.spirit.wonderingtrader.WonderingTraderEntity;
import com.klikli_dev.occultism.registry.OccultismCommands;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismPotions;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;

@EventBusSubscriber(modid="occultism")
public class ForgeEventHandler {
    @SubscribeEvent
    public static void onBrewingRecipeRegister(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, OccultismItems.OTHERWORLD_ESSENCE.asItem(), OccultismPotions.THIRD_EYE_POTION);
        builder.addMix(OccultismPotions.THIRD_EYE_POTION, Items.REDSTONE, OccultismPotions.LONG_THIRD_EYE_POTION);
        builder.addMix(Potions.NIGHT_VISION, OccultismItems.DATURA.asItem(), OccultismPotions.THIRD_EYE_POTION);
        builder.addMix(Potions.LONG_NIGHT_VISION, OccultismItems.DATURA.asItem(), OccultismPotions.LONG_THIRD_EYE_POTION);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        OccultismCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onTraderSpawn(FinalizeSpawnEvent event) {
        WanderingTrader trader;
        block10: {
            block9: {
                if (event.isSpawnCancelled() || event.isCanceled()) {
                    return;
                }
                if (event.getSpawnType() != MobSpawnType.EVENT) {
                    return;
                }
                Mob mob = event.getEntity();
                if (!(mob instanceof WanderingTrader)) break block9;
                trader = (WanderingTrader)mob;
                if (!(event.getEntity() instanceof WonderingTraderEntity)) break block10;
            }
            return;
        }
        if (RandomSource.create().nextInt(100) >= Occultism.SERVER_CONFIG.spiritJobs.traderWonderingChance.getAsInt()) {
            return;
        }
        Level level = trader.level();
        if (level.isClientSide) {
            return;
        }
        if (trader.getPersistentData().getBoolean("replaced")) {
            return;
        }
        trader.getPersistentData().putBoolean("replaced", true);
        level.playSound(null, trader.blockPosition(), OccultismSounds.START_RITUAL.get(), SoundSource.AMBIENT, 2.0f, 3.0f);
        WonderingTraderEntity wondering = (WonderingTraderEntity)OccultismEntities.WONDERING_TRADER.get().spawn((ServerLevel)level, trader.blockPosition(), MobSpawnType.EVENT);
        if (wondering == null) {
            return;
        }
        wondering.setDespawnDelay(48000);
        wondering.setReplacedTrader(trader);
        wondering.setPersistenceRequired();
    }
}

