/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.worldgen;

import com.klikli_dev.occultism.datagen.worldgen.ConfiguredFeatures;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class PlacedFeatures {
    public static final ResourceKey<PlacedFeature> ORE_SILVER = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ore_silver"));
    public static final ResourceKey<PlacedFeature> ORE_SILVER_DEEPSLATE = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ore_silver_deepslate"));
    public static final ResourceKey<PlacedFeature> ORE_IESNIUM = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ore_iesnium"));
    public static final ResourceKey<PlacedFeature> TREE_OTHERWORLD = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"tree_otherworld"));
    public static final ResourceKey<PlacedFeature> TREE_OTHERWORLD_NATURAL = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"tree_otherworld_natural"));
    public static final ResourceKey<PlacedFeature> GROVE_UNDERGROUND = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"grove_underground"));

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, ORE_SILVER, (Holder)configuredFeatures.getOrThrow(ConfiguredFeatures.ORE_SILVER), PlacedFeatures.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)50), (VerticalAnchor)VerticalAnchor.absolute((int)200))));
        PlacementUtils.register(context, ORE_SILVER_DEEPSLATE, (Holder)configuredFeatures.getOrThrow(ConfiguredFeatures.ORE_SILVER_DEEPSLATE), PlacedFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)50))));
        PlacementUtils.register(context, ORE_IESNIUM, (Holder)configuredFeatures.getOrThrow(ConfiguredFeatures.ORE_IESNIUM), PlacedFeatures.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)128))));
        PlacementUtils.register(context, TREE_OTHERWORLD, (Holder)configuredFeatures.getOrThrow(ConfiguredFeatures.TREE_OTHERWORLD), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING.get()))});
        PlacementUtils.register(context, TREE_OTHERWORLD_NATURAL, (Holder)configuredFeatures.getOrThrow(ConfiguredFeatures.TREE_OTHERWORLD_NATURAL), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get()))});
        PlacementUtils.register(context, GROVE_UNDERGROUND, (Holder)configuredFeatures.getOrThrow(ConfiguredFeatures.GROVE_UNDERGROUND), List.of());
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier rarity, PlacementModifier height) {
        return List.of(rarity, InSquarePlacement.spread(), height, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int pCount, PlacementModifier pHeightRange) {
        return PlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)pCount), pHeightRange);
    }

    private static List<PlacementModifier> rareOrePlacement(int pChance, PlacementModifier pHeightRange) {
        return PlacedFeatures.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)pChance), pHeightRange);
    }
}

