/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book.binding_rituals;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DimensionalMineshaftEntry
extends EntryProvider {
    public static final String ENTRY_ID = "craft_dimensional_mineshaft";

    public DimensionalMineshaftEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("spotlight", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.DIMENSIONAL_MINESHAFT.asItem()})).withText(this.context().pageText()));
        this.pageText(" The dimensional mineshaft houses a {0} which opens up a stable connection into an\n  uninhabited dimension, perfectly suited for mining. While the portal is too small\n   to transfer humans, other spirits can use it to enter the mining dimension and bring back resources.\n\n", new Object[]{this.color("Djinni", ChatFormatting.DARK_PURPLE)});
        this.page("ritual", () -> (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_dimensional_mineshaft")));
        this.page("description", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Operation");
        this.pageText("The dimensional mineshaft will discard any items it cannot store, so it is important\nto regularly empty the mineshaft, either manually, with hoppers or using a transporter spirit.\\\nInteractions per side:\n+ Top -> lamp slot;\n+ Bottom -> ores slots;\n+ Other -> all slots;\n");
        this.page("redstone", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Redstone");
        this.pageText(" The dimensional mineshaft has two interactions with redstone:\n 1. The spirit will stop working when receives a redstone signal;\n 2. A comparator can be used to extract a signal based on occupied slots and lamp durability.\n  Tip, if the comparator sends a power of 10, it is better to stop the operations.\n");
        this.page("enchantment", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Enchantments");
        this.pageText("You've noticed that your miner can be enchanted? Here's how effective it is!\\\n **Efficiency:** Increase the progress bar by the smaller of two RNB;\\\n **Fortune:** Mine a number of extra results equals smaller of three RNB;\\\n **Silk touch:** Multiply the count of mined result by 1 plus a RNB;\\\n RNB = random number between 0 and the enchantment level.\n");
        this.page("enchantment2", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Durability");
        this.pageText("The **Unbreaking** and **Mending** enchantments function as vanilla.\n\\\n With other methods (mods) you can make your miner unusable (**unusing**)\n when it's close to breaking, or even truly unbreakable (**eternal**).\n");
        this.page("config", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Config");
        this.pageText("If you want to save your miners before they break, check \"Server Configuration > Items\".\n By setting the \"Save miners before breaking\" option to \"on\", a miner will go to the output\n of the dimensional mineshaft when it reaches 1 durability. The effects of enchantments can also be turned off.\n");
    }

    protected String entryName() {
        return "Dimensional Mineshaft";
    }

    protected String entryDescription() {
        return "Void mining";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.asItem());
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

