/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryReadConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookModLoadedConditionModel;
import com.klikli_dev.occultism.datagen.OccultismBookProvider;
import com.klikli_dev.occultism.datagen.book.binding_rituals.StabilizedStorageEntry;
import com.klikli_dev.occultism.datagen.book.binding_rituals.StabilizerTier1Entry;
import com.klikli_dev.occultism.datagen.book.binding_rituals.StabilizerTier2Entry;
import com.klikli_dev.occultism.datagen.book.binding_rituals.StabilizerTier3Entry;
import com.klikli_dev.occultism.datagen.book.binding_rituals.StabilizerTier4Entry;
import com.klikli_dev.occultism.datagen.book.binding_rituals.StabilizerTier5Entry;
import com.klikli_dev.occultism.datagen.book.binding_rituals.StableWormholeEntry;
import com.klikli_dev.occultism.datagen.book.binding_rituals.StorageRemoteEntry;
import com.klikli_dev.occultism.datagen.book.storage_system.AutomationEntry;
import com.klikli_dev.occultism.datagen.book.storage_system.AutomationTheurgyEntry;
import com.klikli_dev.occultism.datagen.book.storage_system.ControllerEntry;
import com.klikli_dev.occultism.datagen.book.storage_system.StabilizerEntry;
import com.klikli_dev.occultism.datagen.book.storage_system.StorageOverviewEntry;
import com.klikli_dev.occultism.datagen.book.summoning_rituals.ManageMachineEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class StorageCategory
extends CategoryProvider {
    public static final String CATEGORY_ID = "storage";

    public StorageCategory(OccultismBookProvider parent) {
        super((ModonomiconProviderBase)parent);
    }

    protected String categoryName() {
        return "Magic Storage";
    }

    protected BookIconModel categoryIcon() {
        return BookIconModel.create((ItemLike)Items.CHEST);
    }

    public String categoryId() {
        return CATEGORY_ID;
    }

    protected String[] generateEntryMap() {
        return new String[]{"___________________", "_______t___________", "___________________", "_______a_w_1_2_____", "___________________", "___9_0_c___s_3_f___", "___________________", "_______m_r___4_5___", "___________________"};
    }

    protected void generateEntries() {
        String craftFoliotID = this.modId() + ":pentacles/craft_foliot";
        String craftDjinniID = this.modId() + ":pentacles/craft_djinni";
        String craftAfritID = this.modId() + ":pentacles/craft_afrit";
        String craftMaridID = this.modId() + ":pentacles/craft_marid";
        String contactEldritchID = this.modId() + ":pentacles/contact_eldritch_spirit";
        BookEntryModel overview = this.add(new StorageOverviewEntry(this).generate('0')).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftDjinniID));
        BookEntryModel returnToCrafting = this.add(this.makeReturnToCraftingEntry(this.entryMap));
        returnToCrafting.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId()));
        BookEntryModel storageController = this.add(new ControllerEntry(this).generate('c'));
        storageController.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftDjinniID));
        BookEntryModel storageSystemAutomation = this.add(new AutomationEntry(this).generate('a'));
        storageSystemAutomation.withParent(BookEntryParentModel.create((ResourceLocation)storageController.getId()));
        BookEntryModel storageSystemAutomationTheurgy = this.add(new AutomationTheurgyEntry(this).generate('t'));
        storageSystemAutomationTheurgy.withParent(BookEntryParentModel.create((ResourceLocation)storageSystemAutomation.getId()));
        storageSystemAutomationTheurgy.withCondition((BookConditionModel)BookModLoadedConditionModel.create().withModId("theurgy"));
        BookEntryModel summonManageMachine = this.add(new ManageMachineEntry(this).generate('m'));
        summonManageMachine.withParent(BookEntryParentModel.create((ResourceLocation)storageController.getId()));
        BookEntryModel craftStableWormhole = this.add(new StableWormholeEntry(this).generate('w'));
        craftStableWormhole.withParent(BookEntryParentModel.create((ResourceLocation)storageController.getId()));
        BookEntryModel craftStorageRemote = this.add(new StorageRemoteEntry(this).generate('r'));
        craftStorageRemote.withParent(BookEntryParentModel.create((ResourceLocation)storageController.getId()));
        BookEntryModel storageStabilizer = this.add(new StabilizerEntry(this).generate('s'));
        storageStabilizer.withParent(BookEntryParentModel.create((ResourceLocation)storageController.getId()));
        BookEntryModel craftStabilizerTier1 = this.add(new StabilizerTier1Entry(this).generate('1'));
        craftStabilizerTier1.withParent(BookEntryParentModel.create((ResourceLocation)storageStabilizer.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftFoliotID));
        BookEntryModel craftStabilizerTier2 = this.add(new StabilizerTier2Entry(this).generate('2'));
        craftStabilizerTier2.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier1.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftDjinniID));
        BookEntryModel craftStabilizerTier3 = this.add(new StabilizerTier3Entry(this).generate('3'));
        craftStabilizerTier3.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier2.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftAfritID));
        BookEntryModel craftStabilizerTier4 = this.add(new StabilizerTier4Entry(this).generate('4'));
        craftStabilizerTier4.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier3.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftMaridID));
        BookEntryModel craftStabilizerTier5 = this.add(new StabilizerTier5Entry(this).generate('5'));
        craftStabilizerTier5.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier4.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(contactEldritchID));
        BookEntryModel stabilizedStorage = this.add(new StabilizedStorageEntry(this).generate('f'));
        stabilizedStorage.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier5.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(contactEldritchID));
    }

    private BookEntryModel makeReturnToCraftingEntry(CategoryEntryMap entryMap) {
        this.context().entry("return_to_crafting");
        this.lang().add(this.context().entryName(), "Return to Binding Rituals Category");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/infusion.png")).withCategoryToOpen(this.modLoc("crafting_rituals")).withEntryBackground(1, 2).withLocation(entryMap.get(Character.valueOf('9')));
    }
}

