/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.spirit.wonderingtrader;

import com.klikli_dev.occultism.common.entity.spirit.wonderingtrader.WonderingTrades;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismParticles;
import com.klikli_dev.occultism.util.CuriosUtil;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WonderingTraderEntity
extends WanderingTrader
implements GeoEntity {
    AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    protected MerchantOffers otherOffers;
    @Nullable
    protected MerchantOffers commonOffers;
    protected WanderingTrader replacedTrader = null;

    public WonderingTraderEntity(EntityType<? extends WonderingTraderEntity> type, Level level) {
        super(type, level);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        this.offers = player.hasEffect(OccultismEffects.THIRD_EYE) || CuriosUtil.hasGoggles(player) || CuriosUtil.hasStaff(player) ? this.otherOffers : this.commonOffers;
        if (!itemstack.is(Items.VILLAGER_SPAWN_EGG) && this.isAlive() && !this.isTrading() && !this.isBaby()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.awardStat(Stats.TALKED_TO_VILLAGER);
            }
            if (!this.level().isClientSide) {
                if (this.getOffers().isEmpty()) {
                    return InteractionResult.CONSUME;
                }
                this.setTradingPlayer(player);
                Component name = this.getDisplayName() == null ? this.getName() : this.getDisplayName();
                this.openTradingScreen(player, name, 1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.EVENT) {
            for (int t = 0; t < 2; ++t) {
                TraderLlama traderllama;
                BlockPos blockpos = null;
                SpawnPlacementType spawnplacementtype = SpawnPlacements.getPlacementType((EntityType)EntityType.WANDERING_TRADER);
                for (int i = 0; i < 10; ++i) {
                    int k;
                    int l;
                    int j = this.blockPosition().getX() + level.getRandom().nextInt(8) - 4;
                    BlockPos blockpos1 = new BlockPos(j, l = level.getHeight(Heightmap.Types.WORLD_SURFACE, j, k = this.blockPosition().getZ() + level.getRandom().nextInt(8) - 4), k);
                    if (!spawnplacementtype.isSpawnPositionOk((LevelReader)level, blockpos1, EntityType.WANDERING_TRADER)) continue;
                    blockpos = blockpos1;
                    break;
                }
                if (blockpos == null || (traderllama = (TraderLlama)EntityType.TRADER_LLAMA.spawn((ServerLevel)level, blockpos, MobSpawnType.EVENT)) == null) continue;
                traderllama.setLeashedTo((Entity)this, true);
                traderllama.setPersistenceRequired();
            }
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.replacedTrader != null) {
                WanderingTrader wanderingTrader = this.replacedTrader;
                for (TraderLlama llama : this.level().getEntitiesOfClass(TraderLlama.class, wanderingTrader.getBoundingBox().inflate(8.0), Entity::isAlive)) {
                    if (llama.getLeashHolder() == null || !llama.getLeashHolder().is((Entity)wanderingTrader)) continue;
                    llama.remove(Entity.RemovalReason.DISCARDED);
                }
                wanderingTrader.discard();
                this.replacedTrader = null;
            }
            if (this.level().getGameTime() % 20L == 0L) {
                Vec3 pos = this.position();
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, pos.x + this.level().random.nextGaussian() / 3.0, pos.y + 0.5, pos.z + this.level().random.nextGaussian() / 3.0, this.level().random.nextInt(4), 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void setReplacedTrader(WanderingTrader wanderingTrader) {
        this.replacedTrader = wanderingTrader;
    }

    public void die(@NotNull DamageSource damageSource) {
        super.die(damageSource);
        if (!this.level().isClientSide() && !this.isAlive()) {
            Vec3 pos = this.position();
            for (int i = 0; i < 30; ++i) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)OccultismParticles.RITUAL_WAITING.get(), pos.x + this.level().random.nextGaussian() / 3.0, pos.y + 0.2, pos.z + this.level().random.nextGaussian() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @NotNull
    public MerchantOffers getOffers() {
        if (this.level().isClientSide) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
            if (this.commonOffers == null) {
                this.commonOffers = this.offers;
            } else if (this.otherOffers == null) {
                this.otherOffers = this.offers;
            }
        }
        if (this.otherOffers == null) {
            this.otherOffers = new MerchantOffers();
            this.updateOtherTrades();
        }
        return this.offers;
    }

    public MerchantOffers getCommonOffers() {
        if (this.level().isClientSide) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.commonOffers == null) {
            if (this.offers == null) {
                this.offers = new MerchantOffers();
                this.updateTrades();
            }
            this.commonOffers = this.offers;
        }
        return this.commonOffers;
    }

    public MerchantOffers getOtherOffers() {
        if (this.level().isClientSide) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.otherOffers == null) {
            this.otherOffers = new MerchantOffers();
            this.updateOtherTrades();
        }
        return this.otherOffers;
    }

    protected void updateTrades() {
        if (this.level().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE)) {
            super.updateTrades();
        } else {
            VillagerTrades.ItemListing[] hint = (VillagerTrades.ItemListing[])WonderingTrades.WONDERING_TRADES.get(0);
            VillagerTrades.ItemListing[] listing = (VillagerTrades.ItemListing[])VillagerTrades.WANDERING_TRADER_TRADES.get(1);
            VillagerTrades.ItemListing[] listing1 = (VillagerTrades.ItemListing[])VillagerTrades.WANDERING_TRADER_TRADES.get(2);
            if (listing != null && listing1 != null) {
                MerchantOffers merchantoffers = this.getOffers();
                if (hint != null) {
                    this.addOffersFromItemListings(merchantoffers, hint, 1);
                }
                this.addOffersFromItemListings(merchantoffers, listing, 5);
                int i = this.random.nextInt(listing1.length);
                VillagerTrades.ItemListing villagertrades$itemlisting = listing1[i];
                MerchantOffer merchantoffer = villagertrades$itemlisting.getOffer((Entity)this, this.random);
                if (merchantoffer != null) {
                    merchantoffers.add((Object)merchantoffer);
                }
            }
        }
    }

    protected void updateOtherTrades() {
        VillagerTrades.ItemListing[] list1 = (VillagerTrades.ItemListing[])WonderingTrades.WONDERING_TRADES.get(1);
        VillagerTrades.ItemListing[] list2 = (VillagerTrades.ItemListing[])WonderingTrades.WONDERING_TRADES.get(2);
        VillagerTrades.ItemListing[] list3 = (VillagerTrades.ItemListing[])WonderingTrades.WONDERING_TRADES.get(3);
        VillagerTrades.ItemListing[] list4 = (VillagerTrades.ItemListing[])WonderingTrades.WONDERING_TRADES.get(4);
        VillagerTrades.ItemListing[] list5 = (VillagerTrades.ItemListing[])WonderingTrades.WONDERING_TRADES.get(5);
        VillagerTrades.ItemListing[] list6 = (VillagerTrades.ItemListing[])WonderingTrades.WONDERING_TRADES.get(6);
        VillagerTrades.ItemListing[] list7 = (VillagerTrades.ItemListing[])WonderingTrades.WONDERING_TRADES.get(7);
        VillagerTrades.ItemListing[] list8 = (VillagerTrades.ItemListing[])WonderingTrades.WONDERING_TRADES.get(8);
        if (list1 != null && list2 != null && list3 != null && list4 != null && list5 != null && list6 != null && list7 != null && list8 != null) {
            MerchantOffers merchantoffers = this.getOtherOffers();
            this.addOffersFromItemListings(merchantoffers, list1, 1);
            this.addOffersFromItemListings(merchantoffers, list2, this.random.nextIntBetweenInclusive(1, 3));
            this.addOffersFromItemListings(merchantoffers, list3, this.random.nextIntBetweenInclusive(1, 2));
            this.addOffersFromItemListings(merchantoffers, list4, 1);
            this.addOffersFromItemListings(merchantoffers, list5, this.random.nextIntBetweenInclusive(1, 3));
            this.addOffersFromItemListings(merchantoffers, list6, 1);
            if (this.random.nextBoolean()) {
                this.addOffersFromItemListings(merchantoffers, list7, 1);
            } else if (this.random.nextBoolean()) {
                this.addOffersFromItemListings(merchantoffers, list8, 1);
            }
        }
    }

    public int getCurrentSwingDuration() {
        return 11;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController mainController = new AnimationController((GeoAnimatable)this, "mainController", 5, this::animPredicate);
        controllers.add(mainController);
    }

    private <T extends GeoAnimatable> PlayState animPredicate(AnimationState<T> tAnimationState) {
        if (this.swinging) {
            return tAnimationState.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        if (tAnimationState.isMoving()) {
            return tAnimationState.setAndContinue(RawAnimation.begin().thenLoop("walk"));
        }
        return tAnimationState.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (!this.level().isClientSide) {
            MerchantOffers other;
            MerchantOffers common = this.getCommonOffers();
            if (!common.isEmpty()) {
                compound.put("CommonOffers", (Tag)MerchantOffers.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)common).getOrThrow());
            }
            if (!(other = this.getOtherOffers()).isEmpty()) {
                compound.put("OtherOffers", (Tag)MerchantOffers.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)other).getOrThrow());
            }
        }
        this.writeInventoryToTag(compound, (HolderLookup.Provider)this.registryAccess());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("CommonOffers")) {
            MerchantOffers.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("CommonOffers")).result().ifPresent(p_323775_ -> {
                this.commonOffers = p_323775_;
            });
        }
        if (compound.contains("OtherOffers")) {
            MerchantOffers.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("OtherOffers")).result().ifPresent(p_323775_ -> {
                this.otherOffers = p_323775_;
            });
        }
        this.readInventoryFromTag(compound, (HolderLookup.Provider)this.registryAccess());
    }
}

