/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.possessed.horde;

import com.klikli_dev.occultism.common.entity.possessed.PossessedMob;
import com.klikli_dev.occultism.common.entity.possessed.horde.WildCaveSpiderEntity;
import com.klikli_dev.occultism.common.entity.possessed.horde.WildSpiderEntity;
import com.klikli_dev.occultism.common.entity.possessed.horde.WildStrayEntity;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;

public class PossessedBreezeEntity
extends Breeze
implements PossessedMob {
    List<WildSpiderEntity> minionsA = new ArrayList<WildSpiderEntity>();
    List<WildStrayEntity> minionsB = new ArrayList<WildStrayEntity>();
    List<WildCaveSpiderEntity> minionsC = new ArrayList<WildCaveSpiderEntity>();

    public PossessedBreezeEntity(EntityType<? extends Breeze> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Breeze.createAttributes().add(Attributes.MAX_HEALTH, 150.0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        double offsetZ;
        double offsetX;
        PossessedMob entity;
        int i;
        for (i = 0; i < 5; ++i) {
            entity = (WildSpiderEntity)OccultismEntities.WILD_SPIDER.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
            ((WildSpiderEntity)entity).setMaster(this);
            this.minionsA.add((WildSpiderEntity)entity);
        }
        for (i = 0; i < 5; ++i) {
            entity = (WildStrayEntity)OccultismEntities.WILD_STRAY.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
            ((WildStrayEntity)entity).setMaster(this);
            this.minionsB.add((WildStrayEntity)entity);
        }
        for (i = 0; i < 5; ++i) {
            entity = (WildCaveSpiderEntity)OccultismEntities.WILD_CAVE_SPIDER.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
            ((WildCaveSpiderEntity)entity).setMaster(this);
            this.minionsC.add((WildCaveSpiderEntity)entity);
        }
        return super.finalizeSpawn(level, difficultyIn, reason, spawnDataIn);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        TagKey<EntityType<?>> wildTrialTag = OccultismTags.Entities.WILD_TRIAL;
        Entity trueSource = source.getEntity();
        if (trueSource != null && trueSource.getType().is(wildTrialTag)) {
            return true;
        }
        Entity immediateSource = source.getDirectEntity();
        if (immediateSource != null && immediateSource.getType().is(wildTrialTag)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.minionsA.isEmpty()) {
            this.minionsA.forEach(e -> e.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0, false, false)));
        }
        if (!this.minionsB.isEmpty()) {
            this.minionsB.forEach(e -> e.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0, false, false)));
        }
        if (!this.minionsC.isEmpty()) {
            this.minionsC.forEach(e -> e.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0, false, false)));
        }
        return super.hurt(source, (float)((double)amount * (1.0 - (double)(this.minionsA.size() + this.minionsB.size() + this.minionsC.size()) / 16.0)));
    }

    public void notifyMinionDeath(WildSpiderEntity minion) {
        this.minionsA.remove(minion);
    }

    public void notifyMinionDeath(WildStrayEntity minion) {
        this.minionsB.remove(minion);
    }

    public void notifyMinionDeath(WildCaveSpiderEntity minion) {
        this.minionsC.remove(minion);
    }

    @Override
    public EntityType basedMob() {
        return EntityType.BREEZE;
    }
}

