/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.ai.goal.PickupItemsGoal;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.crafting.recipe.SpiritTradeRecipe;
import com.klikli_dev.occultism.crafting.recipe.TraderRecipeInput;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedRecipeResult;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityEvent;

public class TraderJob
extends SpiritJob {
    public static final String DROPPED_BY_TRADER = "occultism:dropped_by_trader";
    protected int conversionTimer;
    protected int timeToConvert;
    protected int maxTradesPerRound;
    protected PickupItemsGoal pickupItemsGoal;
    protected List<Ingredient> itemsToPickUp = new ArrayList<Ingredient>();
    protected List<RecipeHolder<SpiritTradeRecipe>> currentRecipe = List.of();
    protected List<WeightedRecipeResult> possibleResults;

    public TraderJob(SpiritEntity entity, Supplier<Integer> timeToConvert, Supplier<Integer> maxTradesPerRound) {
        super(entity);
        this.timeToConvert = timeToConvert.get();
        this.maxTradesPerRound = maxTradesPerRound.get();
    }

    public int getTimeToConvert() {
        return this.timeToConvert;
    }

    public void setTimeToConvert(int timeToConvert) {
        this.timeToConvert = timeToConvert;
    }

    public void setMaxTradesPerRound(int trades) {
        this.maxTradesPerRound = trades;
    }

    @Override
    public void onInit() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.targetSelector.addGoal(1, (Goal)this.pickupItemsGoal);
        this.itemsToPickUp = this.entity.level().getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.SPIRIT_TRADE_TYPE.get()).stream().filter(recipe -> {
            String recipeTrader = ((SpiritTradeRecipe)recipe.value()).getTrader();
            return recipeTrader.equals(this.getFactoryID().toString());
        }).flatMap(recipe -> ((SpiritTradeRecipe)recipe.value()).getIngredients().stream()).collect(Collectors.toList());
    }

    @Override
    public void cleanup() {
        this.entity.targetSelector.removeGoal((Goal)this.pickupItemsGoal);
    }

    @Override
    public void update() {
        ItemStack handHeld = this.entity.getItemInHand(InteractionHand.MAIN_HAND);
        TraderRecipeInput recipeInput = new TraderRecipeInput(handHeld, this.getFactoryID().toString());
        if (this.currentRecipe.isEmpty() && !handHeld.isEmpty()) {
            this.currentRecipe = this.entity.level().getRecipeManager().getRecipesFor((RecipeType)OccultismRecipes.SPIRIT_TRADE_TYPE.get(), (RecipeInput)recipeInput, this.entity.level());
            this.conversionTimer = 0;
            if (!this.currentRecipe.isEmpty()) {
                this.entity.level().playSound(null, this.entity.blockPosition(), OccultismSounds.START_RITUAL.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.getRandom().nextFloat());
                this.possibleResults = this.currentRecipe.stream().map(r -> ((SpiritTradeRecipe)r.value()).getWeightedResult()).collect(Collectors.toList());
            } else {
                this.entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                ItemEntity droppedItem = this.entity.spawnAtLocation(handHeld);
                if (droppedItem != null) {
                    droppedItem.addTag(DROPPED_BY_TRADER);
                }
            }
        }
        if (!this.currentRecipe.isEmpty()) {
            if (handHeld.isEmpty() || !((SpiritTradeRecipe)this.currentRecipe.get(0).value()).matches(recipeInput, this.entity.level())) {
                this.currentRecipe = List.of();
            } else {
                ++this.conversionTimer;
                if (this.entity.level().getGameTime() % 10L == 0L) {
                    Vec3 pos = this.entity.position();
                    ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, pos.x + this.entity.level().random.nextGaussian() / 3.0, pos.y + 0.5, pos.z + this.entity.level().random.nextGaussian() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.conversionTimer % 40 == 0) {
                    this.entity.level().playSound(null, this.entity.blockPosition(), OccultismSounds.POOF.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.getRandom().nextFloat());
                }
                if (this.conversionTimer >= this.timeToConvert) {
                    this.conversionTimer = 0;
                    int a = Math.min(this.maxTradesPerRound, handHeld.getCount());
                    for (int i = 0; i < a; ++i) {
                        Optional result = WeightedRandom.getRandomItem((RandomSource)this.entity.getRandom(), this.possibleResults);
                        result.ifPresent(r -> {
                            ItemEntity droppedItem;
                            ItemStack finalResult = r.getStack().copy();
                            finalResult.setCount(finalResult.getCount());
                            ItemStack inputCopy = handHeld.copy();
                            handHeld.shrink(1);
                            this.onConvert(inputCopy, finalResult);
                            TraderJobEvent event = new TraderJobEvent((Entity)this.entity, inputCopy, finalResult);
                            NeoForge.EVENT_BUS.post((Event)event);
                            if (!event.getResult().isEmpty() && (droppedItem = this.entity.spawnAtLocation(event.getResult())) != null) {
                                droppedItem.addTag(DROPPED_BY_TRADER);
                            }
                        });
                    }
                }
            }
        }
        super.update();
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("timeToConvert", this.timeToConvert);
        compound.putInt("conversionTimer", this.conversionTimer);
        compound.putInt("maxTradesPerRound", this.maxTradesPerRound);
        return super.writeJobToNBT(compound, provider);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        super.readJobFromNBT(compound, provider);
        this.timeToConvert = compound.getInt("timeToConvert");
        this.conversionTimer = compound.getInt("conversionTimer");
        this.maxTradesPerRound = compound.getInt("maxTradesPerRound");
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        if (entity.getTags().contains(DROPPED_BY_TRADER) && entity.getAge() < (Integer)Occultism.SERVER_CONFIG.spiritJobs.traderResultPickupDelay.get()) {
            return false;
        }
        ItemStack stack = entity.getItem();
        return !stack.isEmpty() && this.itemsToPickUp.stream().anyMatch(i -> i.test(stack));
    }

    @Override
    public List<Ingredient> getItemsToPickUp() {
        return this.itemsToPickUp;
    }

    public void onConvert(ItemStack input, ItemStack output) {
    }

    public static class TraderJobEvent
    extends EntityEvent {
        private ItemStack input;
        private ItemStack result;

        public TraderJobEvent(Entity entity, ItemStack input, ItemStack result) {
            super(entity);
            this.input = input;
            this.result = result;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public void setInput(ItemStack input) {
            this.input = input;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }
    }
}

