/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.common.entity.ai.sensor.NearestTreeSensor;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class FellTreeBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final double FELL_TREE_RANGE_SQUARE = Math.pow(3.5, 2.0);
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(OccultismMemoryTypes.NEAREST_TREE.get(), (Object)MemoryStatus.VALUE_PRESENT)});
    protected int breakingTime;
    protected int previousBreakProgress;

    public FellTreeBehaviour() {
        this.runtimeProvider = entity -> 200;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        BlockPos treePos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
        double dist = entity.distanceToSqr(Vec3.atCenterOf((Vec3i)treePos));
        return dist <= FELL_TREE_RANGE_SQUARE;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
    }

    protected void tick(E entity) {
        BlockPos treePos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
        if (NearestTreeSensor.isLog(entity.level(), treePos)) {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(treePos));
            ++this.breakingTime;
            entity.swing(InteractionHand.MAIN_HAND, true);
            int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
            if (this.breakingTime % 20 == 0) {
                entity.playSound(SoundEvents.WOOD_HIT, 1.0f, 1.0f);
                entity.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, 0.5f);
            }
            if (i != this.previousBreakProgress) {
                entity.level().destroyBlockProgress(entity.getId(), treePos, i);
                this.previousBreakProgress = i;
            }
            if (this.breakingTime == 160) {
                entity.playSound(SoundEvents.WOOD_BREAK, 1.0f, 1.0f);
                ArrayList<BlockPos> stump = new ArrayList<BlockPos>(List.of());
                this.addAllStump(treePos, (BlockGetter)entity.level(), stump);
                this.fellTree(entity, treePos);
                ArrayList<BlockPos> felled = (ArrayList<BlockPos>)BrainUtils.getMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get());
                if (felled != null) {
                    felled.addAll(stump);
                } else {
                    felled = stump;
                }
                BrainUtils.setMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get(), felled);
                this.stop((ServerLevel)entity.level(), (LivingEntity)entity, entity.level().getGameTime());
            }
        } else {
            this.stop((ServerLevel)entity.level(), (LivingEntity)entity, entity.level().getGameTime());
        }
    }

    protected void start(E entity) {
        this.breakingTime = 0;
        this.previousBreakProgress = -1;
    }

    protected void stop(E entity) {
        BrainUtils.clearMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
    }

    private void fellTree(E entity, BlockPos treePos) {
        Level level = entity.level();
        BlockPos base = treePos;
        ArrayDeque<BlockPos> blocks = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        blocks.add(base);
        while (!blocks.isEmpty()) {
            BlockPos pos2;
            BlockPos pos = (BlockPos)blocks.remove();
            if (!visited.add(pos) || !NearestTreeSensor.isLog(level, pos)) continue;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                pos2 = pos.relative(facing);
                if (visited.contains(pos2)) continue;
                blocks.add(pos2);
            }
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    pos2 = pos.offset(-1 + x, 1, -1 + z);
                    if (visited.contains(pos2)) continue;
                    blocks.add(pos2);
                }
            }
            level.destroyBlock(pos, true);
        }
    }

    private void addAllStump(BlockPos pos, BlockGetter level, List<BlockPos> list) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos posR = pos.relative(facing);
            if (list.contains(posR) || !level.getBlockState(posR).is(BlockTags.LOGS) || !level.getBlockState(posR.below()).is(BlockTags.DIRT)) continue;
            list.add(posR);
            this.addAllStump(posR, level, list);
        }
    }
}

