/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.api.common.data.OtherworldBlockTier;
import com.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.util.CuriosUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class ThirdEyeEffectRenderer {
    public static final int MAX_THIRD_EYE_DISTANCE = 10;
    public static final ResourceLocation THIRD_EYE_SHADER = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"shaders/post/third_eye.json");
    public static final ResourceLocation THIRD_EYE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/overlay/third_eye.png");
    public boolean thirdEyeActiveLastTick = false;
    public boolean gogglesActiveLastTick = false;
    public Set<BlockPos> uncoveredBlocks = new HashSet<BlockPos>();

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide && event.getEntity() == Minecraft.getInstance().player) {
            this.onThirdEyeTick(event);
            this.onGogglesTick(event);
            this.onStaffTick(event);
        }
    }

    public void renderOverlay(PoseStack pose) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)THIRD_EYE_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Window window = Minecraft.getInstance().getWindow();
        pose.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(0.0f, (float)window.getGuiScaledHeight(), -90.0f).setUv(0.0f, 1.0f);
        buffer.addVertex((float)window.getGuiScaledWidth(), (float)window.getGuiScaledHeight(), -90.0f).setUv(1.0f, 1.0f);
        buffer.addVertex((float)window.getGuiScaledWidth(), 0.0f, -90.0f).setUv(1.0f, 0.0f);
        buffer.addVertex(0.0f, 0.0f, -90.0f).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        pose.popPose();
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void resetUncoveredBlocks(Level level, boolean clear) {
        for (BlockPos pos : this.uncoveredBlocks) {
            BlockState state = level.getBlockState(pos);
            if (!(state.getBlock() instanceof IOtherworldBlock)) continue;
            level.setBlock(pos, (BlockState)state.setValue(IOtherworldBlock.UNCOVERED, (Comparable)Boolean.valueOf(false)), 1);
        }
        if (clear) {
            this.uncoveredBlocks.clear();
        }
    }

    public void uncoverBlocks(Player player, Level level, OtherworldBlockTier tier) {
        BlockPos origin = player.blockPosition();
        BlockPos.betweenClosed((BlockPos)origin.offset(-10, -10, -10), (BlockPos)origin.offset(10, 10, 10)).forEach(pos -> {
            IOtherworldBlock block;
            BlockState state = level.getBlockState(pos);
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof IOtherworldBlock && (block = (IOtherworldBlock)patt0$temp).getTier().getLevel() <= tier.getLevel()) {
                if (!((Boolean)state.getValue(IOtherworldBlock.UNCOVERED)).booleanValue()) {
                    level.setBlock(pos, (BlockState)state.setValue(IOtherworldBlock.UNCOVERED, (Comparable)Boolean.valueOf(true)), 8);
                }
                this.uncoveredBlocks.add(pos.immutable());
            }
        });
    }

    public void onThirdEyeTick(PlayerTickEvent.Post event) {
        int duration;
        boolean hasGoggles = CuriosUtil.hasGoggles(event.getEntity());
        if (hasGoggles) {
            return;
        }
        MobEffectInstance effect = event.getEntity().getEffect(OccultismEffects.THIRD_EYE);
        int n = duration = effect == null ? 0 : effect.getDuration();
        if (duration > 1) {
            if (!this.thirdEyeActiveLastTick) {
                this.thirdEyeActiveLastTick = true;
                if (!((Boolean)Occultism.CLIENT_CONFIG.visuals.disableDemonsDreamShaders.get()).booleanValue()) {
                    Minecraft.getInstance().tell(() -> Minecraft.getInstance().gameRenderer.loadEffect(THIRD_EYE_SHADER));
                }
            }
            this.uncoverBlocks(event.getEntity(), event.getEntity().level(), OtherworldBlockTier.ONE);
        } else {
            this.resetUncoveredBlocks(event.getEntity().level(), duration == 0);
            if (this.thirdEyeActiveLastTick) {
                this.thirdEyeActiveLastTick = false;
                if (!((Boolean)Occultism.CLIENT_CONFIG.visuals.disableDemonsDreamShaders.get()).booleanValue()) {
                    Minecraft.getInstance().tell(() -> Minecraft.getInstance().gameRenderer.shutdownEffect());
                }
            }
        }
    }

    public void onGogglesTick(PlayerTickEvent.Post event) {
        boolean hasGoggles = CuriosUtil.hasGoggles(event.getEntity());
        if (hasGoggles) {
            if (!this.gogglesActiveLastTick) {
                this.gogglesActiveLastTick = true;
            }
            this.uncoverBlocks(event.getEntity(), event.getEntity().level(), OtherworldBlockTier.TWO);
        } else if (this.gogglesActiveLastTick) {
            this.gogglesActiveLastTick = false;
            this.resetUncoveredBlocks(event.getEntity().level(), true);
            if (this.thirdEyeActiveLastTick) {
                this.uncoverBlocks(event.getEntity(), event.getEntity().level(), OtherworldBlockTier.ONE);
            }
        }
    }

    public void onStaffTick(PlayerTickEvent.Post event) {
        if (CuriosUtil.hasStaff(event.getEntity())) {
            this.uncoverBlocks(event.getEntity(), event.getEntity().level(), OtherworldBlockTier.TWO);
        } else {
            if (!this.gogglesActiveLastTick) {
                this.resetUncoveredBlocks(event.getEntity().level(), true);
            }
            if (this.thirdEyeActiveLastTick) {
                this.uncoverBlocks(event.getEntity(), event.getEntity().level(), OtherworldBlockTier.ONE);
            }
        }
    }
}

