/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlockGeneratorBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.worldgen.LocatedStructure;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.Filterable;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.BlockHitResult;

public class RoadSignFeature
extends Feature<Config> {
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();
    private static final BlockState PATH = Blocks.DIRT_PATH.defaultBlockState();
    private static final BlockState SANDSTONE_PATH = Blocks.SMOOTH_SANDSTONE.defaultBlockState();

    public RoadSignFeature() {
        super(Config.CODEC);
    }

    public static boolean isNotSolid(LevelAccessor world, BlockPos pos) {
        return !world.isStateAtPosition(pos, state -> state.isRedstoneConductor((BlockGetter)world, pos));
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        WorldGenLevel reader = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        Config c = (Config)context.config();
        pos = pos.below();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                for (int k = 1; k <= 4; ++k) {
                    if ((Math.abs(i) == 2 || Math.abs(j) == 2) && k == 1) continue;
                    reader.setBlock(pos.offset(i, k, j), ModRegistry.STRUCTURE_TEMP.get().defaultBlockState(), 2);
                }
            }
        }
        float humidity = SuppPlatformStuff.getDownfall((Biome)reader.getBiome(pos).value());
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                reader.setBlock(pos.offset(i, -1, j), c.cobble, 2);
                BlockPos pathPos = pos.offset(i, 0, j);
                double dist = pos.distToCenterSqr((double)pathPos.getX(), (double)pathPos.getY(), (double)pathPos.getZ()) / (double)5.2f;
                if ((double)rand.nextFloat() < dist - 0.15) continue;
                boolean m = (double)humidity * 0.75 > (double)rand.nextFloat();
                reader.setBlock(pathPos, m ? c.mossyCobble : c.cobble, 2);
            }
        }
        boolean m = (double)humidity * 0.75 > (double)rand.nextFloat();
        pos = pos.above();
        reader.setBlock(pos, m ? c.mossyWall : c.wall, 2);
        pos = pos.above();
        reader.setBlock(pos, c.fence, 2);
        pos = pos.above();
        reader.setBlock(pos, c.fence, 2);
        reader.setBlock(pos.above(), ModRegistry.BLOCK_GENERATOR.get().defaultBlockState(), 2);
        BlockEntity blockEntity = reader.getBlockEntity(pos.above());
        if (blockEntity instanceof BlockGeneratorBlockTile) {
            BlockGeneratorBlockTile t = (BlockGeneratorBlockTile)blockEntity;
            t.setConfig(c);
        } else {
            Supplementaries.LOGGER.error("Failed to get Road Sign Block Entity during generation. How did this happen?");
        }
        return true;
    }

    public static void applyPostProcess(Config c, ServerLevel level, BlockPos generatorPos, List<LocatedStructure> foundVillages) {
        RandomState r = c.randomState;
        BlockState topState = c.trapdoor;
        BlockPos pos = generatorPos.below(2);
        ArrayList<Pair> villages = new ArrayList<Pair>();
        for (LocatedStructure str : foundVillages) {
            villages.add(Pair.of((Object)((int)Math.sqrt(str.distSqrt())), (Object)str.position()));
        }
        boolean inVillage = false;
        if (inVillage) {
            Holder b = level.getBiome(pos);
            BlockState replace = b.is(BiomeTags.HAS_VILLAGE_DESERT) ? SANDSTONE_PATH : PATH;
            RoadSignFeature.replaceCobbleWithPath(c, (Level)level, pos, replace);
        }
        if (!villages.isEmpty()) {
            BlockPos village2;
            int dist2;
            BlockPos village1;
            int dist1;
            RandomSource rand = level.random;
            boolean twoSigns = true;
            if (villages.size() == 1 || r.doubleSignChance > rand.nextFloat() && (Integer)((Pair)villages.get(0)).getFirst() > 192) {
                dist1 = (Integer)((Pair)villages.getFirst()).getFirst();
                village1 = (BlockPos)((Pair)villages.getFirst()).getSecond();
                dist2 = dist1;
                village2 = village1;
                twoSigns = false;
            } else {
                boolean inv = rand.nextBoolean();
                dist1 = (Integer)((Pair)villages.get(inv ? 0 : 1)).getFirst();
                village1 = (BlockPos)((Pair)villages.get(inv ? 0 : 1)).getSecond();
                dist2 = (Integer)((Pair)villages.get(inv ? 1 : 0)).getFirst();
                village2 = (BlockPos)((Pair)villages.get(inv ? 1 : 0)).getSecond();
            }
            level.setBlockAndUpdate(pos, ModRegistry.WAY_SIGN.get().defaultBlockState());
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SignPostBlockTile) {
                Direction backDir;
                float yaw;
                float diff;
                SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
                tile.setHeldBlock(c.fence);
                boolean left = rand.nextBoolean();
                SignPostBlockTile.Sign up = tile.getSignUp();
                SignPostBlockTile.Sign down = tile.getSignDown();
                up.setActive(true);
                up.setLeft(left);
                up.setWoodType(c.signWood);
                up.pointToward(tile.getBlockPos(), village1);
                down.setActive(twoSigns);
                down.setLeft(left);
                down.setWoodType(c.signWood);
                down.pointToward(tile.getBlockPos(), village2);
                if (Math.abs(up.yaw() - down.yaw()) > 90.0f) {
                    down.toggleDirection();
                    down.pointToward(tile.getBlockPos(), village2);
                }
                if (CommonConfigs.Building.ROAD_SIGN_DISTANCE_TEXT.get().booleanValue()) {
                    tile.getTextHolder(0).setMessage(0, RoadSignFeature.getSignText(dist1));
                    if (twoSigns) {
                        tile.getTextHolder(1).setMessage(0, RoadSignFeature.getSignText(dist2));
                    }
                }
                Direction sideDir = (diff = Mth.degreesDifference((float)(yaw = Mth.wrapDegrees((float)(90.0f + 360.0f * MthUtils.averageAngles((Float[])new Float[]{Float.valueOf((180.0f - up.yaw()) / 360.0f), Float.valueOf((180.0f - down.yaw()) / 360.0f)})))), (float)(backDir = Direction.fromYRot((double)yaw)).toYRot())) < 0.0f ? backDir.getClockWise() : backDir.getCounterClockWise();
                ArrayList<Direction> lampDir = new ArrayList<Direction>();
                lampDir.add(backDir.getOpposite());
                lampDir.add(backDir.getOpposite());
                lampDir.add(backDir.getOpposite());
                if (Math.abs(diff) > 30.0f) {
                    lampDir.add(sideDir.getOpposite());
                }
                boolean hasGroundLantern = false;
                boolean hasFirefly = false;
                if (rand.nextFloat() < r.stoneChance && Mth.degreesDifferenceAbs((float)(tile.getPointingYaw(true) + 180.0f), (float)yaw) > 70.0f) {
                    BlockPos stonePos = pos.below().offset(backDir.getNormal());
                    if (rand.nextBoolean()) {
                        level.setBlock(stonePos, c.stoneSlab, 2);
                    } else {
                        level.setBlock(stonePos, (BlockState)c.stoneStairs.setValue((Property)StairBlock.FACING, (Comparable)sideDir), 2);
                    }
                    stonePos = stonePos.offset(sideDir.getNormal());
                    level.setBlock(stonePos, c.stone, 2);
                    if (rand.nextFloat() < r.stoneLanternChance) {
                        level.setBlock(stonePos.above(), hasFirefly ? c.lanternDown : c.lanternDown, 3);
                        hasGroundLantern = true;
                    }
                    if (!RoadSignFeature.isNotSolid((LevelAccessor)level, (stonePos = stonePos.offset(sideDir.getNormal())).below())) {
                        if (rand.nextBoolean()) {
                            level.setBlock(stonePos, c.stoneSlab, 2);
                        } else {
                            level.setBlock(stonePos, (BlockState)c.stoneStairs.setValue((Property)StairBlock.FACING, (Comparable)sideDir.getOpposite()), 2);
                        }
                    }
                }
                if (!hasGroundLantern) {
                    Block wl;
                    boolean doubleSided;
                    BlockState light;
                    pos = pos.above(2);
                    BlockState blockState = light = hasFirefly ? c.lanternUp : c.lanternUp;
                    if (rand.nextFloat() < r.candleHolderChance) {
                        light = (BlockState)((BlockState)c.candleHolder.setValue((Property)CandleHolderBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue(CandleHolderBlock.FACE, (Comparable)AttachFace.CEILING);
                    }
                    Direction dir = (Direction)lampDir.get(rand.nextInt(lampDir.size()));
                    boolean bl = doubleSided = r.doubleLanternChance > rand.nextFloat();
                    if (doubleSided) {
                        dir = dir.getClockWise();
                    }
                    if ((wl = (Block)CompatObjects.WALL_LANTERN.get()) != null && rand.nextFloat() < r.wallLanternChance) {
                        topState = rand.nextFloat() < r.trapdoorChance ? c.trapdoor : AIR;
                        RoadSignFeature.placeWallLantern(c.lanternDown, level, dir, wl, pos.below());
                        if (doubleSided) {
                            RoadSignFeature.placeWallLantern(c.lanternDown, level, dir.getOpposite(), wl, pos.below());
                        }
                    } else {
                        boolean isTrapdoor;
                        boolean bl2 = isTrapdoor = r.trapdoorChance > rand.nextFloat();
                        if (!isTrapdoor) {
                            topState = c.fence;
                        }
                        if (doubleSided) {
                            BlockPos backPos = pos.relative(dir.getOpposite());
                            level.setBlock(backPos, isTrapdoor ? c.trapdoor : c.fence, 2);
                            if (r.logChance > rand.nextFloat()) {
                                topState = isTrapdoor ? c.slab : c.log;
                            }
                            level.setBlock(backPos.below(), light, 3);
                        }
                        pos = pos.relative(dir);
                        BlockState frontState = isTrapdoor ? c.trapdoor : c.fence;
                        level.setBlock(pos, frontState, 2);
                        level.setBlock(pos.below(), light, 3);
                    }
                }
            }
        } else {
            ItemStack book = new ItemStack((ItemLike)Items.WRITABLE_BOOK);
            WritableBookContent content = new WritableBookContent(List.of(new Filterable((Object)"nothing here but monsters\n\n\n", Optional.empty())));
            book.set(DataComponents.WRITABLE_BOOK_CONTENT, (Object)content);
            BlockPos belowPos = generatorPos.below(2);
            level.setBlockAndUpdate(belowPos, (BlockState)((BlockState)ModRegistry.NOTICE_BOARD.get().defaultBlockState().setValue((Property)NoticeBoardBlock.HAS_BOOK, (Comparable)Boolean.valueOf(true))).setValue((Property)NoticeBoardBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(level.random)));
            BlockEntity blockEntity = level.getBlockEntity(belowPos);
            if (blockEntity instanceof NoticeBoardBlockTile) {
                NoticeBoardBlockTile board = (NoticeBoardBlockTile)blockEntity;
                board.setDisplayedItem(book);
            }
        }
        level.setBlock(generatorPos, topState, 3);
    }

    private static Component getSignText(int d) {
        int s = d < 100 ? 10 : (d < 2000 ? 100 : 1000);
        return Component.translatable((String)"message.supplementaries.road_sign", (Object[])new Object[]{(d + s / 2) / s * s});
    }

    private static void replaceCobbleWithPath(Config c, Level world, BlockPos pos, BlockState path) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                BlockPos pathPos;
                BlockState state;
                if (Math.abs(i) == 2 && Math.abs(j) == 2 || i == 0 && j == 0 || !(state = world.getBlockState(pathPos = pos.offset(i, -2, j))).is(c.cobble.getBlock()) && !state.is(c.mossyCobble.getBlock())) continue;
                world.setBlock(pathPos, path, 2);
            }
        }
    }

    private static void placeWallLantern(BlockState lanternState, ServerLevel level, Direction dir, Block wallLantern, BlockPos pos) {
        BlockEntity blockEntity;
        pos = pos.relative(dir);
        BlockState state = wallLantern.getStateForPlacement(new BlockPlaceContext((Level)level, null, InteractionHand.MAIN_HAND, wallLantern.asItem().getDefaultInstance(), new BlockHitResult(pos.getCenter(), dir, pos, false)));
        if (state != null) {
            level.setBlockAndUpdate(pos, state);
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof IBlockHolder) {
            IBlockHolder tt = (IBlockHolder)blockEntity;
            tt.setHeldBlock(lanternState);
        }
    }

    public record Config(RandomState randomState, WoodType postWood, WoodType signWood, BlockState fence, BlockState trapdoor, BlockState slab, BlockState log, BlockState cobble, BlockState mossyCobble, BlockState wall, BlockState mossyWall, BlockState lanternUp, BlockState lanternDown, BlockState candleHolder, BlockState stone, BlockState stoneSlab, BlockState stoneStairs, String invalidMessage) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RandomState.CODEC.fieldOf("random_state").forGetter(Config::randomState), (App)WoodType.CODEC.fieldOf("post_wood").forGetter(Config::postWood), (App)WoodType.CODEC.fieldOf("sign_wood").forGetter(Config::signWood), (App)BlockState.CODEC.fieldOf("cobble").forGetter(Config::cobble), (App)BlockState.CODEC.fieldOf("mossy_cobble").forGetter(Config::mossyCobble), (App)BlockState.CODEC.fieldOf("wall").forGetter(Config::wall), (App)BlockState.CODEC.fieldOf("mossy_wall").forGetter(Config::mossyWall), (App)BlockState.CODEC.fieldOf("lantern_up").forGetter(Config::lanternUp), (App)BlockState.CODEC.fieldOf("lantern_down").forGetter(Config::lanternDown), (App)BlockState.CODEC.fieldOf("candle_holder").forGetter(Config::candleHolder), (App)BlockState.CODEC.fieldOf("stone").forGetter(Config::stone), (App)BlockState.CODEC.fieldOf("stone_slab").forGetter(Config::stoneSlab), (App)BlockState.CODEC.fieldOf("stone_stairs").forGetter(Config::stoneStairs)).apply((Applicative)instance, Config::of)).comapFlatMap(s -> {
            if (s.invalidMessage != null) {
                return DataResult.error(() -> s.invalidMessage);
            }
            return DataResult.success((Object)s);
        }, Function.identity());

        private static Config of(RandomState randomState, WoodType postWood, WoodType signWood, BlockState cobble, BlockState mossyCobble, BlockState wall, BlockState mossyWall, BlockState lanternUp, BlockState lanternDown, BlockState candleHolder, BlockState stone, BlockState stoneSlab, BlockState stoneStairs) {
            Block log;
            Block slab;
            Block trapdoor;
            Object message = null;
            Block fence = postWood.getBlockOfThis("fence");
            if (fence == null) {
                message = "Post wood explosionType does not have a fence";
                fence = Blocks.AIR;
            }
            if ((trapdoor = postWood.getBlockOfThis("trapdoor")) == null) {
                message = "Post wood explosionType does not have a trapdoor";
                trapdoor = Blocks.AIR;
            }
            if ((slab = postWood.getBlockOfThis("slab")) == null) {
                message = "Post wood explosionType does not have a slab";
                slab = Blocks.AIR;
            }
            if ((log = postWood.getBlockOfThis("stripped_log")) == null) {
                message = "Post wood explosionType does not have a valid stripped log";
                log = Blocks.AIR;
            }
            if (!(stoneSlab.getBlock() instanceof SlabBlock)) {
                message = "Stone slab must be a SlabBlock, was " + String.valueOf(stoneSlab);
            }
            if (!(stoneStairs.getBlock() instanceof StairBlock)) {
                message = "Stone slab must be a StairBlock, was " + String.valueOf(stoneStairs);
            }
            if (!candleHolder.hasProperty(CandleHolderBlock.FACE) || !candleHolder.hasProperty((Property)CandleHolderBlock.LIT)) {
                message = "Candle holder block has to have a face and lit property";
            }
            return new Config(randomState, postWood, signWood, fence.defaultBlockState(), trapdoor.defaultBlockState(), slab.defaultBlockState(), log.defaultBlockState(), cobble, mossyCobble, wall, mossyWall, lanternUp, lanternDown, candleHolder, stone, stoneSlab, stoneStairs, (String)message);
        }
    }

    private record RandomState(float doubleSignChance, float stoneChance, float stoneLanternChance, float candleHolderChance, float wallLanternChance, float doubleLanternChance, float trapdoorChance, float logChance) {
        public static final Codec<RandomState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("double_sign_chance").forGetter(RandomState::doubleSignChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stone_chance").forGetter(RandomState::stoneChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stone_lantern_chance").forGetter(RandomState::stoneLanternChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("candle_holder_chance").forGetter(RandomState::candleHolderChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("wall_lantern_chance").forGetter(RandomState::wallLanternChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("double_lantern_chance").forGetter(RandomState::doubleLanternChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trapdoor_chance").forGetter(RandomState::trapdoorChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("log_chance").forGetter(RandomState::logChance)).apply((Applicative)instance, RandomState::new));
    }
}

