/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.google.common.collect.BiMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.utils.BlockPredicate;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SoapWashableHelper {
    public static boolean canCleanColor(Block block) {
        if (block.builtInRegistryHolder().is(ModTags.SOAP_BLACKLIST_BLOCK)) {
            return false;
        }
        return !CommonConfigs.Functional.SOAP_DYE_CLEAN_BLACKLIST.get().contains(BlocksColorAPI.getKey((Block)block));
    }

    public static boolean canCleanColor(Item item) {
        if (item.builtInRegistryHolder().is(ModTags.SOAP_BLACKLIST_ITEM)) {
            return false;
        }
        return !CommonConfigs.Functional.SOAP_DYE_CLEAN_BLACKLIST.get().contains(BlocksColorAPI.getKey((Item)item));
    }

    public static boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        if (SoapWashableHelper.tryWashWithInterface(level, pos, state, hitVec) || SoapWashableHelper.tryCleaningSign(level, pos, state) || SoapWashableHelper.tryChangingColor(level, pos, state) || SoapWashableHelper.tryCleaningPiston(level, pos, state) || SoapWashableHelper.tryCleanFromConfig(level, pos, state) || SoapWashableHelper.tryUnWax(level, pos, state)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                NetworkHelper.sendToAllClientPlayersInParticleRange((ServerLevel)serverLevel, (BlockPos)pos, (CustomPacketPayload)new ClientBoundParticlePacket(pos, ClientBoundParticlePacket.Kind.BUBBLE_CLEAN));
            }
            return true;
        }
        return false;
    }

    private static boolean tryCleaningSign(Level level, BlockPos pos, BlockState state) {
        SignBlockEntity te;
        BlockEntity blockEntity;
        if (state.getBlock() instanceof SignBlock && (blockEntity = level.getBlockEntity(pos)) instanceof SignBlockEntity && (te = (SignBlockEntity)blockEntity).isWaxed()) {
            te.setWaxed(false);
            if (!level.isClientSide) {
                te.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
            }
            return true;
        }
        return false;
    }

    private static boolean tryUnWax(Level level, BlockPos pos, BlockState state) {
        Block b = state.getBlock();
        BlockState toPlace = null;
        Block unWaxed = (Block)((BiMap)HoneycombItem.WAXABLES.get()).inverse().get((Object)b);
        if (unWaxed != null) {
            toPlace = unWaxed.withPropertiesOf(state);
        }
        if (toPlace == null) {
            toPlace = SoapWashableHelper.tryParseWax(state);
        }
        if (toPlace != null) {
            SoapWashableHelper.replaceWithBlockEntity(level, pos, b, toPlace);
            return true;
        }
        return false;
    }

    private static boolean tryCleaningPiston(Level level, BlockPos pos, BlockState state) {
        if (state.is(Blocks.STICKY_PISTON)) {
            Direction dir = (Direction)state.getValue((Property)PistonBaseBlock.FACING);
            BlockPos headPos = pos.relative(dir);
            BlockState headState = level.getBlockState(headPos);
            if (headState.is(Blocks.PISTON_HEAD) && headState.getValue((Property)PistonHeadBlock.FACING) == dir) {
                level.setBlockAndUpdate(headPos, (BlockState)headState.setValue((Property)PistonHeadBlock.TYPE, (Comparable)PistonType.DEFAULT));
            }
            level.setBlockAndUpdate(pos, Blocks.PISTON.withPropertiesOf(state));
            return true;
        }
        if (state.is(Blocks.PISTON_HEAD) && state.getValue((Property)PistonHeadBlock.TYPE) == PistonType.STICKY) {
            Direction dir = (Direction)state.getValue((Property)PistonHeadBlock.FACING);
            BlockPos basePos = pos.relative(dir.getOpposite());
            BlockState baseState = level.getBlockState(basePos);
            level.setBlockAndUpdate(pos, (BlockState)Blocks.PISTON_HEAD.withPropertiesOf(state).setValue((Property)PistonHeadBlock.TYPE, (Comparable)PistonType.DEFAULT));
            if (baseState.is(Blocks.STICKY_PISTON) && baseState.getValue((Property)PistonBaseBlock.FACING) == dir) {
                level.setBlockAndUpdate(basePos, Blocks.PISTON.withPropertiesOf(baseState));
            }
            return true;
        }
        return false;
    }

    private static boolean tryCleanFromConfig(Level level, BlockPos pos, BlockState state) {
        BlockState toPlace = null;
        for (Map.Entry<BlockPredicate, ResourceLocation> e : CommonConfigs.Functional.SOAP_SPECIAL.get().entrySet()) {
            if (!e.getKey().test(state)) continue;
            toPlace = BuiltInRegistries.BLOCK.getOptional(e.getValue()).map(s -> s.withPropertiesOf(state)).orElse(null);
            break;
        }
        if (toPlace != null) {
            level.setBlock(pos, toPlace, 11);
            return true;
        }
        return false;
    }

    private static BlockState tryParseWax(BlockState oldState) {
        String[] keywords;
        ResourceLocation r = Utils.getID((Block)oldState.getBlock());
        String name = r.getPath();
        for (String key : keywords = new String[]{"waxed_", "_waxed"}) {
            BlockState newState;
            if (!name.contains(key)) continue;
            String newName = name.replace(key, "");
            Optional bb = BuiltInRegistries.BLOCK.getOptional(r.withPath(newName));
            if (bb.isEmpty()) {
                bb = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.parse((String)newName));
            }
            if (!bb.isPresent() || (newState = ((Block)bb.get()).withPropertiesOf(oldState)) == oldState) continue;
            return newState;
        }
        return null;
    }

    private static boolean tryWashWithInterface(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        BlockEntity tile;
        IWashable soapWashable;
        Block b = state.getBlock();
        IWashable cap = b instanceof IWashable ? (soapWashable = (IWashable)b) : SuppPlatformStuff.getForgeCap(level, pos, IWashable.class);
        if (cap == null && (tile = level.getBlockEntity(pos)) != null && tile instanceof IWashable) {
            IWashable soapWashable2;
            cap = soapWashable2 = (IWashable)tile;
        }
        if (cap != null) {
            return cap.tryWash(level, pos, state, hitVec);
        }
        return false;
    }

    private static boolean tryChangingColor(Level level, BlockPos pos, BlockState state) {
        Block newColor = BlocksColorAPI.changeColor((Block)state.getBlock(), null);
        if (newColor != null) {
            if (!SoapWashableHelper.canCleanColor(state.getBlock())) {
                return false;
            }
            if (state.getBlock() instanceof BedBlock) {
                return false;
            }
            BlockState toPlace = newColor.withPropertiesOf(state);
            SoapWashableHelper.replaceWithBlockEntity(level, pos, newColor, toPlace);
            return true;
        }
        return false;
    }

    private static void replaceWithBlockEntity(Level level, BlockPos pos, Block newColor, BlockState toPlace) {
        BlockEntity be;
        BlockEntity oldBe;
        CompoundTag oldBetag = null;
        if (newColor instanceof EntityBlock && (oldBe = level.getBlockEntity(pos)) != null) {
            oldBetag = oldBe.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            level.removeBlockEntity(pos);
        }
        level.setBlock(pos, toPlace, 18);
        if (oldBetag != null && (be = level.getBlockEntity(pos)) != null) {
            be.loadWithComponents(oldBetag, (HolderLookup.Provider)level.registryAccess());
        }
    }
}

