/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class FiniteFluidInteraction
implements FaucetTarget.Fluid,
FaucetSource.Fluid {
    @Override
    public Integer fill(Level level, BlockPos pos, FluidState existing, FluidOffer offer) {
        Holder vanillaF = offer.fluid().getVanillaFluid();
        if (vanillaF instanceof FiniteFluid) {
            FiniteFluid ff = (FiniteFluid)vanillaF;
            int oldLayers = 0;
            if (existing.getType().isSame((Fluid)vanillaF.value())) {
                oldLayers = existing.getAmount();
            } else if (!existing.isEmpty() || !level.getBlockState(pos).isAir()) {
                return null;
            }
            int maxLayers = ff.getLayersPerBlock();
            int missingLayers = maxLayers - oldLayers;
            if (missingLayers <= 0) {
                return 0;
            }
            float offerLayers = this.bottlesToLayers(ff, 1);
            float extraLayers = Math.min((float)missingLayers, offerLayers);
            float consumed = this.layersToBottles(ff, extraLayers);
            level.setBlockAndUpdate(pos, ff.makeState((int)((float)oldLayers + extraLayers)).createLegacyBlock());
            return Math.min(Mth.floor((float)consumed), offer.fluid().getCount());
        }
        return null;
    }

    @Override
    @Nullable
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, FluidState source) {
        FiniteFluid ff;
        int amount;
        Fluid fluid = source.getType();
        if (fluid instanceof FiniteFluid && (amount = this.layersToBottles(ff = (FiniteFluid)fluid, source.getAmount())) > 0) {
            return FluidOffer.of(SoftFluidStack.fromFluid((Fluid)ff, (int)amount, (HolderLookup.Provider)level.registryAccess()));
        }
        return null;
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, FluidState source, int amount) {
        FiniteFluid ff = (FiniteFluid)source.getType();
        int drainedLayers = this.bottlesToLayers(ff, amount);
        int newLayers = Math.max(0, source.getAmount() - drainedLayers);
        if (newLayers == 0) {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        } else {
            level.setBlockAndUpdate(pos, ff.makeState(newLayers).createLegacyBlock());
        }
    }

    private int layersToBottles(FiniteFluid ff, float layers) {
        int maxLayers = ff.getLayersPerBlock();
        float bottleToLayers = (float)maxLayers / 4.0f;
        return (int)(layers / bottleToLayers);
    }

    private int bottlesToLayers(FiniteFluid ff, int bottles) {
        int maxLayers = ff.getLayersPerBlock();
        float bottleToLayers = (float)maxLayers / 4.0f;
        return (int)((float)bottles * bottleToLayers);
    }
}

