/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.GlobeRenderData;
import net.mehvahdjukaar.supplementaries.client.renderers.CapturedMobCache;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.GlobeBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PedestalBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PedestalBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class PedestalBlockTileRenderer
implements BlockEntityRenderer<PedestalBlockTile> {
    private final ItemRenderer itemRenderer;
    private final EntityRenderDispatcher entityRenderer;

    public PedestalBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft minecraft = Minecraft.getInstance();
        this.itemRenderer = minecraft.getItemRenderer();
        this.entityRenderer = minecraft.getEntityRenderDispatcher();
    }

    public AABB getRenderBoundingBox(BlockEntity tile) {
        return new AABB(tile.getBlockPos()).expandTowards(0.0, 1.0, 0.0);
    }

    protected boolean canRenderName(ItemStack item, PedestalBlockTile tile, PedestalBlockTile.DisplayType type) {
        if (Minecraft.renderNames() && item.has(DataComponents.CUSTOM_NAME) && !type.isGlobe()) {
            double d0 = this.entityRenderer.distanceToSqr((double)tile.getBlockPos().getX() + 0.5, (double)tile.getBlockPos().getY() + 0.5, (double)tile.getBlockPos().getZ() + 0.5);
            return d0 < 256.0;
        }
        return false;
    }

    public static void renderName(Component name, float h, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft mc = Minecraft.getInstance();
        int s = "Dinnerbone".equals(name.getString()) ? -1 : 1;
        poseStack.scale((float)s, (float)s, 1.0f);
        boolean i = false;
        poseStack.pushPose();
        poseStack.translate(0.0f, h, 0.0f);
        poseStack.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.025f, -0.025f, -0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f1 = mc.options.getBackgroundOpacity(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        float f2 = (float)(-mc.font.width((FormattedText)name)) / 2.0f;
        mc.font.drawInBatch(name, f2, (float)i, -1, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, j, combinedLightIn);
        poseStack.popPose();
    }

    public void render(PedestalBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.isEmpty()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, 1.125, 0.5);
            PedestalBlockTile.DisplayType displayType = tile.getDisplayType();
            ItemStack stack = tile.getDisplayedItem();
            if (this.canRenderName(stack, tile, displayType)) {
                PedestalBlockTileRenderer.renderName(tile.getItem(0).getHoverName(), 0.875f, matrixStackIn, bufferIn, combinedLightIn);
            }
            matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            matrixStackIn.translate(0.0, 0.25, 0.0);
            if (tile.getBlockState().getValue(PedestalBlock.AXIS) == Direction.Axis.X) {
                matrixStackIn.mulPose(RotHlpr.Y90);
            }
            ItemDisplayContext transform = ItemDisplayContext.FIXED;
            if (ClientConfigs.Blocks.PEDESTAL_SPECIAL.get().booleanValue()) {
                switch (displayType) {
                    case SWORD: {
                        matrixStackIn.translate(0.0, -0.03125, 0.0);
                        matrixStackIn.scale(1.5f, 1.5f, 1.5f);
                        matrixStackIn.mulPose(RotHlpr.Z135);
                        break;
                    }
                    case TRIDENT: {
                        matrixStackIn.translate(0.0, 0.03125, 0.0);
                        matrixStackIn.scale(1.5f, 1.5f, 1.5f);
                        matrixStackIn.mulPose(RotHlpr.ZN45);
                        break;
                    }
                    case CRYSTAL: {
                        this.entityRenderer.render((Entity)CapturedMobCache.getEndCrystal(tile.getLevel()), 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                        matrixStackIn.popPose();
                        return;
                    }
                    default: {
                        if (ClientConfigs.Blocks.PEDESTAL_SPIN.get().booleanValue()) {
                            matrixStackIn.translate(0.0f, 0.375f, 0.0f);
                            matrixStackIn.scale(1.5f, 1.5f, 1.5f);
                            int scale = (int)(ClientConfigs.Blocks.PEDESTAL_SPEED.get() * 360.0);
                            long time = tile.getLevel().getGameTime();
                            float angle = ((float)Math.floorMod(time, (long)scale) + partialTicks) / (float)scale;
                            Quaternionf rotation = Axis.YP.rotation((float)((double)angle * Math.PI * 10.0));
                            matrixStackIn.mulPose(rotation);
                        }
                        if (!displayType.isGlobe()) break;
                        if (GlobeBlockTileRenderer.INSTANCE != null) {
                            boolean sepia = tile.getDisplayType() == PedestalBlockTile.DisplayType.SEPIA_GLOBE;
                            GlobeRenderData data = GlobeManager.computeRenderData(false, (Component)stack.get(DataComponents.CUSTOM_NAME));
                            GlobeBlockTileRenderer.INSTANCE.renderGlobe(data, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, sepia, tile.getLevel());
                        }
                        matrixStackIn.popPose();
                        return;
                    }
                }
            }
            if (MiscUtils.FESTIVITY.isAprilsFool()) {
                stack = new ItemStack((ItemLike)Items.DIRT);
            }
            this.itemRenderer.renderStatic(stack, transform, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, tile.getLevel(), 0);
            matrixStackIn.popPose();
        }
    }
}

