/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BaseReusableItem
extends BaseItem {
    private static final DeferredHolder<Enchantment, Enchantment> UNBREAKING_ENCHANTMENT = DeferredHolder.create((ResourceKey)Enchantments.UNBREAKING);
    private final boolean unbreakable;
    private final boolean tooltip;

    public BaseReusableItem(int uses) {
        this(uses, (Item.Properties p) -> p);
    }

    public BaseReusableItem(Function<Item.Properties, Item.Properties> properties) {
        this(true, properties);
    }

    public BaseReusableItem(boolean tooltip, Function<Item.Properties, Item.Properties> properties) {
        this(0, tooltip, properties);
    }

    public BaseReusableItem(int uses, Function<Item.Properties, Item.Properties> properties) {
        this(uses, true, properties);
    }

    public BaseReusableItem(int uses, boolean tooltip, Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.durability(Math.max(uses - 1, 0)).setNoRepair()));
        this.unbreakable = uses < 1;
        this.tooltip = tooltip;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack copy = stack.copyWithCount(1);
        if (this.unbreakable) {
            return copy;
        }
        int unbreaking = stack.getEnchantmentLevel(UNBREAKING_ENCHANTMENT);
        if (Math.random() > (double)(1.0f / (float)(unbreaking + 1))) {
            return copy;
        }
        int newDamage = stack.getDamageValue() + 1;
        if (newDamage > stack.getMaxDamage()) {
            return ItemStack.EMPTY;
        }
        copy.setDamageValue(newDamage);
        return copy;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (this.tooltip) {
            if (!this.unbreakable) {
                int damage = stack.getMaxDamage() - stack.getDamageValue() + 1;
                if (damage == 1) {
                    tooltip.add((Component)Tooltips.ONE_USE_LEFT.build());
                } else {
                    tooltip.add((Component)Tooltips.USES_LEFT.args(damage).build());
                }
            } else {
                tooltip.add((Component)Tooltips.UNLIMITED_USES.build());
            }
        }
    }
}

