/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.util;

import com.almostreliable.ponderjs.PonderJS;
import com.almostreliable.ponderjs.util.PonderErrorHelper;
import dev.latvian.mods.kubejs.block.predicate.BlockIDPredicate;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderTag;
import net.createmod.ponder.foundation.SelectionImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static final TypeInfo VEC_TYPE = TypeInfo.of(Vec3.class);

    public static Selection selectionOf(Context ctx, @Nullable Object o) {
        if (o instanceof Selection) {
            Selection s = (Selection)o;
            return s;
        }
        if (o instanceof BoundingBox) {
            BoundingBox box = (BoundingBox)o;
            return SelectionImpl.of((BoundingBox)box);
        }
        if (o instanceof BlockPos) {
            BlockPos b = (BlockPos)o;
            return SelectionImpl.of((BoundingBox)new BoundingBox(b));
        }
        if (o instanceof List) {
            List l = (List)o;
            if (l.stream().anyMatch(Objects::isNull)) {
                ConsoleJS.CLIENT.warn((Object)"Selection was provided as list with invalid values. This may happen if a comma is missing. Please check your code.");
            }
            if (l.size() == 2) {
                Vec3 from = (Vec3)ctx.jsToJava(l.get(0), VEC_TYPE);
                Vec3 to = (Vec3)ctx.jsToJava(l.get(1), VEC_TYPE);
                return SelectionImpl.of((BoundingBox)new BoundingBox((int)from.x, (int)from.y, (int)from.z, (int)to.x, (int)to.y, (int)to.z));
            }
            Integer[] values = (Integer[])l.stream().map(entry -> {
                try {
                    return (int)Double.parseDouble(entry.toString());
                }
                catch (Exception e) {
                    ConsoleJS.CLIENT.error("Selection was provided as list with invalid values.", (Throwable)e);
                    return 0;
                }
            }).toArray(Integer[]::new);
            if (values.length == 6) {
                return SelectionImpl.of((BoundingBox)new BoundingBox(values[0].intValue(), values[1].intValue(), values[2].intValue(), values[3].intValue(), values[4].intValue(), values[5].intValue()));
            }
            if (values.length == 3) {
                return SelectionImpl.of((BoundingBox)new BoundingBox(values[0].intValue(), values[1].intValue(), values[2].intValue(), values[0].intValue(), values[1].intValue(), values[2].intValue()));
            }
        }
        Vec3 v = (Vec3)ctx.jsToJava(o, VEC_TYPE);
        return SelectionImpl.of((BoundingBox)new BoundingBox(new BlockPos((int)v.x, (int)v.y, (int)v.z)));
    }

    public static PonderTag ponderTagOf(@Nullable Object o) {
        Objects.requireNonNull(o);
        PonderTag ponderTag = PonderJS.getTagByName(o.toString()).orElse(null);
        if (ponderTag == null) {
            IllegalArgumentException e = new IllegalArgumentException("Invalid PonderTag: " + String.valueOf(o));
            PonderErrorHelper.yeet(e);
            throw e;
        }
        return ponderTag;
    }

    public static BlockIDPredicate createBlockID(BlockState state) {
        BlockIDPredicate predicate = new BlockIDPredicate(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()));
        for (Map.Entry entry : state.getValues().entrySet()) {
            predicate.with(((Property)entry.getKey()).getName(), ((Comparable)entry.getValue()).toString());
        }
        return predicate;
    }
}

