/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.particles;

import com.almostreliable.ponderjs.particles.ParticleTransformation;
import dev.latvian.mods.kubejs.color.KubeColor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ScalableParticleOptionsBase;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class ParticleDataBuilder<O extends ParticleDataBuilder<O, PO>, PO extends ParticleOptions> {
    final List<ParticleTransformation> transformations = new ArrayList<ParticleTransformation>();
    int density = 1;
    @Nullable
    Float gravity = null;
    @Nullable
    Boolean physics = null;
    @Nullable
    Boolean collision = null;
    @Nullable
    KubeColor color = null;
    @Nullable
    Float roll = null;
    @Nullable
    Float friction = null;
    @Nullable
    Float scale = null;
    @Nullable
    Integer lifetime = null;

    public O density(int density) {
        this.density = density;
        return this.getSelf();
    }

    public O gravity(float gravity) {
        this.gravity = Float.valueOf(gravity);
        return this.getSelf();
    }

    public O physics(boolean physics) {
        this.physics = physics;
        return this.getSelf();
    }

    public O collision(boolean collision) {
        this.collision = collision;
        return this.getSelf();
    }

    public O color(KubeColor color) {
        this.color = color;
        return this.getSelf();
    }

    public O roll(float roll) {
        this.roll = Float.valueOf(roll);
        return this.getSelf();
    }

    public O friction(float friction) {
        this.friction = Float.valueOf(friction);
        return this.getSelf();
    }

    public O scale(float scale) {
        this.scale = Float.valueOf(scale);
        return this.getSelf();
    }

    public O lifetime(int lifetime) {
        this.lifetime = lifetime;
        return this.getSelf();
    }

    public O motion(Vec3 motion) {
        return this.transformMotion((partialTicks, m) -> motion);
    }

    public O speed(Vec3 speed) {
        return this.transformMotion((partialTick, motion) -> new Vec3(Ponder.RANDOM.nextGaussian() * speed.x, Ponder.RANDOM.nextGaussian() * speed.y, Ponder.RANDOM.nextGaussian() * speed.z));
    }

    public O withinBlockSpace() {
        return this.transformPosition((partialTicks, position) -> new Vec3(Math.floor(position.x) + (double)Ponder.RANDOM.nextFloat(), Math.floor(position.y) + (double)Ponder.RANDOM.nextFloat(), Math.floor(position.z) + (double)Ponder.RANDOM.nextFloat()));
    }

    public O area(Vec3 area) {
        return this.transformPosition((partialTicks, position) -> new Vec3(position.x + (double)Ponder.RANDOM.nextFloat() * (area.x - position.x), position.y + (double)Ponder.RANDOM.nextFloat() * (area.y - position.y), position.z + (double)Ponder.RANDOM.nextFloat() * (area.z - position.z)));
    }

    public O delta(Vec3 delta) {
        return this.transformPosition((partialTicks, position) -> new Vec3(position.x + Ponder.RANDOM.nextGaussian() * delta.x, position.y + Ponder.RANDOM.nextGaussian() * delta.y, position.z + Ponder.RANDOM.nextGaussian() * delta.z));
    }

    public O transform(ParticleTransformation transformer) {
        this.transformations.add(transformer);
        return this.getSelf();
    }

    public O transformPosition(ParticleTransformation.Simple transformer) {
        return this.transform(ParticleTransformation.onlyPosition(transformer));
    }

    public O transformMotion(ParticleTransformation.Simple transformer) {
        return this.transform(ParticleTransformation.onlyMotion(transformer));
    }

    abstract PO createOptions();

    protected O getSelf() {
        return (O)this;
    }

    public static class DustParticleDataBuilder
    extends ParticleDataBuilder<DustParticleDataBuilder, ScalableParticleOptionsBase> {
        final KubeColor fromColor;
        @Nullable
        final KubeColor toColor;

        public DustParticleDataBuilder(KubeColor fromColor, @Nullable KubeColor toColor) {
            this.fromColor = fromColor;
            this.toColor = toColor;
        }

        @Override
        public DustParticleDataBuilder color(KubeColor color) {
            return this;
        }

        @Override
        ScalableParticleOptionsBase createOptions() {
            float s = this.scale == null ? 1.0f : this.scale.floatValue();
            Vector3f fC = new Color(this.fromColor.kjs$getRGB()).asVectorF();
            if (this.toColor == null) {
                return new DustParticleOptions(fC, s);
            }
            Vector3f toC = new Color(this.toColor.kjs$getRGB()).asVectorF();
            return new DustColorTransitionOptions(fC, toC, s);
        }
    }

    public static class Static
    extends ParticleDataBuilder<Static, ParticleOptions> {
        private final ParticleOptions type;

        public Static(ParticleOptions type) {
            this.type = type;
        }

        @Override
        ParticleOptions createOptions() {
            return this.type;
        }
    }
}

