/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs;

import com.almostreliable.ponderjs.mixin.TextWindowElementAccessor;
import dev.latvian.mods.rhino.util.HideFromJS;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.TextElementBuilder;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.TextWindowElement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class TextElementBuilderJS
implements TextElementBuilder {
    private final TextWindowElement element;
    private final TextWindowElementAccessor accessor;
    private final PonderScene scene;

    public TextElementBuilderJS(TextWindowElement element, PonderScene scene) {
        this.element = element;
        this.accessor = (TextWindowElementAccessor)element;
        this.scene = scene;
    }

    public TextElementBuilderJS colored(PonderPalette color) {
        this.accessor.setPalette(color);
        return this;
    }

    public TextElementBuilderJS pointAt(Vec3 vec) {
        this.accessor.setVec(vec);
        return this;
    }

    public TextElementBuilderJS independent(int y) {
        this.accessor.setY(y);
        return this;
    }

    public TextElementBuilderJS text(Component component) {
        this.accessor.setTextGetter(() -> ((Component)component).getString());
        return this;
    }

    public TextElementBuilderJS text(Component component, Object ... params) {
        this.accessor.setTextGetter(() -> ((Component)component).getString());
        return this;
    }

    @HideFromJS
    public TextElementBuilderJS text(String defaultText) {
        throw new IllegalStateException("Use text(Component) instead - should not be called from JS");
    }

    @HideFromJS
    public TextElementBuilderJS text(String defaultText, Object ... params) {
        throw new IllegalStateException("Use text(Component, ...params) instead - should not be called from JS");
    }

    public TextElementBuilderJS sharedText(ResourceLocation key) {
        this.accessor.setTextGetter(() -> PonderIndex.getLangAccess().getShared(key));
        return this;
    }

    public TextElementBuilderJS sharedText(ResourceLocation key, Object ... params) {
        this.accessor.setTextGetter(() -> PonderIndex.getLangAccess().getShared(key, params));
        return this;
    }

    @HideFromJS
    public TextElementBuilderJS sharedText(String key) {
        return this.sharedText(ResourceLocation.fromNamespaceAndPath((String)this.scene.getNamespace(), (String)key));
    }

    @HideFromJS
    public TextElementBuilderJS sharedText(String key, Object ... params) {
        return this.sharedText(ResourceLocation.fromNamespaceAndPath((String)this.scene.getNamespace(), (String)key), params);
    }

    public TextElementBuilderJS placeNearTarget() {
        this.accessor.setNearScene(true);
        return this;
    }

    public TextElementBuilderJS attachKeyFrame() {
        this.scene.builder().addLazyKeyframe();
        return this;
    }
}

