/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.lucaargolo.mekanismcovers.MekanismCovers;
import dev.lucaargolo.mekanismcovers.MekanismCoversClient;
import java.util.Iterator;
import java.util.Map;
import mekanism.common.block.transmitter.BlockTransmitter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.pipeline.VertexConsumerWrapper;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ShaderCoverRendering {
    @SubscribeEvent
    static void renderTransparentCovers(RenderLevelStageEvent event) {
        if (!(MekanismCoversClient.ADVANCED_COVER_RENDERING && MekanismCoversClient.SHADER_COVER_RENDERING && MekanismCoversClient.isCoverTransparentFast() && MekanismCoversClient.hasShaderPack())) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        VertexConsumer baseConsumer = mc.renderBuffers().bufferSource().getBuffer(Sheets.translucentCullBlockSheet());
        VertexConsumerWrapper wrappedConsumer = new VertexConsumerWrapper(baseConsumer){

            @NotNull
            public VertexConsumer setColor(int r, int g, int b, int a) {
                super.setColor(r, g, b, 120);
                return this;
            }
        };
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            Iterator<Map.Entry<BlockPos, BlockState>> iterator = MekanismCovers.POSSIBLE_BLOCKS.entrySet().iterator();
            while (iterator.hasNext()) {
                ClientLevel level = mc.level;
                Map.Entry<BlockPos, BlockState> entry = iterator.next();
                if (!level.isLoaded(entry.getKey())) {
                    return;
                }
                if (!(level.getBlockState(entry.getKey()).getBlock() instanceof BlockTransmitter) || entry.getValue() == null) continue;
                Vec3 cameraPos = event.getCamera().getPosition();
                event.getPoseStack().pushPose();
                event.getPoseStack().translate((double)entry.getKey().getX() - cameraPos.x, (double)entry.getKey().getY() - cameraPos.y, (double)entry.getKey().getZ() - cameraPos.z);
                BakedModel model = mc.getModelManager().getBlockModelShaper().getBlockModel(entry.getValue());
                for (RenderType renderType : model.getRenderTypes(entry.getValue(), RandomSource.create(), ModelData.EMPTY)) {
                    mc.getBlockRenderer().getModelRenderer().renderModel(event.getPoseStack().last(), (VertexConsumer)wrappedConsumer, entry.getValue(), model, 1.0f, 1.0f, 1.0f, LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, entry.getKey()), (int)level.getBrightness(LightLayer.SKY, entry.getKey())), OverlayTexture.NO_OVERLAY, model.getModelData((BlockAndTintGetter)level, entry.getKey(), entry.getValue(), ModelData.EMPTY), renderType);
                }
                event.getPoseStack().popPose();
            }
        }
    }

    @SubscribeEvent
    static void changeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() == Minecraft.getInstance().player) {
            MekanismCovers.POSSIBLE_BLOCKS.clear();
        }
    }
}

