/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.gui;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.tile.SimChamberTileEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import dev.shadowsoffire.placebo.menu.FilteredSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class SimChamberContainer
extends BlockEntityMenu<SimChamberTileEntity> {
    public SimChamberContainer(int id, Inventory pInv, BlockPos pos) {
        super(Hostile.Containers.SIM_CHAMBER, id, pInv, pos);
        SimChamberTileEntity.SimItemHandler inventory = ((SimChamberTileEntity)this.tile).getInventory();
        this.addSlot((Slot)new FilteredSlot((InternalItemHandler)inventory, 0, -13, 1, s -> s.getItem() instanceof DataModelItem));
        this.addSlot((Slot)new FilteredSlot((InternalItemHandler)inventory, 1, 176, 7, s -> DataModelItem.matchesModelInput(this.getSlot(0).getItem(), s)));
        this.addSlot((Slot)new FilteredSlot((InternalItemHandler)inventory, 2, 196, 7, s -> false));
        this.addSlot((Slot)new FilteredSlot((InternalItemHandler)inventory, 3, 186, 27, s -> false));
        this.addPlayerSlots(pInv, 36, 153);
        this.mover.registerRule((stack, slot) -> slot < 4, 4, this.slots.size());
        this.mover.registerRule((stack, slot) -> stack.getItem() instanceof DataModelItem, 0, 1);
        this.mover.registerRule((stack, slot) -> DataModelItem.matchesModelInput(this.getSlot(0).getItem(), stack), 1, 2);
        this.registerInvShuffleRules();
    }

    public boolean stillValid(Player pPlayer) {
        return pPlayer.level().getBlockState(this.pos).is(Hostile.Blocks.SIM_CHAMBER);
    }

    public int getEnergyStored() {
        return ((SimChamberTileEntity)this.tile).getEnergyStored();
    }

    public int getRuntime() {
        return ((SimChamberTileEntity)this.tile).getRuntime();
    }

    public boolean didPredictionSucceed() {
        return ((SimChamberTileEntity)this.tile).didPredictionSucceed();
    }

    public SimChamberTileEntity.FailureState getFailState() {
        return ((SimChamberTileEntity)this.tile).getFailState();
    }

    public void setRedstoneState(SimChamberTileEntity.RedstoneState state) {
        ((SimChamberTileEntity)this.tile).setRedstoneState(state);
    }

    public SimChamberTileEntity.RedstoneState getRedstoneState() {
        return ((SimChamberTileEntity)this.tile).getRedstoneState();
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id >= 0 && id <= 2) {
            SimChamberTileEntity.RedstoneState state = SimChamberTileEntity.RedstoneState.values()[id];
            this.setRedstoneState(state);
            return true;
        }
        return super.clickMenuButton(player, id);
    }
}

