/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.cheat;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class SpeedCommand
implements FTBCommand {
    private static final ResourceLocation ESSENTIALS_SPEED_ID = FTBEssentials.essentialsId("speed_boost");

    @Override
    public boolean enabled() {
        return FTBEConfig.SPEED.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"speed").executes(context -> SpeedCommand.speed((CommandSourceStack)context.getSource(), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"boost_percent", (ArgumentType)IntegerArgumentType.integer((int)-100, (int)2000)).requires(cs -> cs.hasPermission(2))).executes(context -> SpeedCommand.speed((CommandSourceStack)context.getSource(), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, ((CommandSourceStack)context.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)context, (String)"boost_percent")))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> SpeedCommand.speed((CommandSourceStack)context.getSource(), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, EntityArgument.getPlayer((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"boost_percent"))))));
    }

    private static int speed(CommandSourceStack source, Holder<Attribute> attr, ServerPlayer player) {
        AttributeInstance attrInstance = player.getAttribute(attr);
        SpeedCommand.showSpeed(source, player, attrInstance);
        return 1;
    }

    private static int speed(CommandSourceStack source, Holder<Attribute> attr, ServerPlayer target, int boostPct) {
        AttributeInstance attrInstance = target.getAttribute(attr);
        if (attrInstance != null) {
            float speedMult = (float)boostPct / 100.0f;
            attrInstance.removeModifier(ESSENTIALS_SPEED_ID);
            if (speedMult != 0.0f) {
                attrInstance.addPermanentModifier(new AttributeModifier(ESSENTIALS_SPEED_ID, (double)speedMult, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            }
            SpeedCommand.showSpeed(source, target, attrInstance);
        }
        return 1;
    }

    private static void showSpeed(CommandSourceStack source, ServerPlayer target, AttributeInstance attrInstance) {
        MutableComponent msg;
        if (attrInstance != null && attrInstance.getModifier(ESSENTIALS_SPEED_ID) != null) {
            AttributeModifier modifier = attrInstance.getModifier(ESSENTIALS_SPEED_ID);
            assert (modifier != null);
            double speedMult = modifier.amount();
            int boostPct = (int)(speedMult * 100.0);
            msg = Component.translatable((String)"ftbessentials.speed_boost", (Object[])new Object[]{target.getDisplayName(), Component.translatable((String)((Attribute)attrInstance.getAttribute().value()).getDescriptionId()), boostPct});
        } else {
            msg = Component.translatable((String)"ftbessentials.speed_boost.none", (Object[])new Object[]{target.getDisplayName()});
        }
        source.sendSuccess(() -> SpeedCommand.lambda$showSpeed$4((Component)msg), false);
        if (!source.isPlayer() || source.getPlayer() != target) {
            target.displayClientMessage((Component)msg, false);
        }
    }

    private static /* synthetic */ Component lambda$showSpeed$4(Component msg) {
        return msg;
    }
}

